/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.messaging;

import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingServiceTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class MessagingServiceRenderer
extends Renderer {
    private final List<Service.Messaging> services;

    public MessagingServiceRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.services = graph.serviceList(Service::isMessaging).map(Service::asMessaging).collect(Collectors.toList());
    }

    @Override
    public void render() {
        this.services.forEach(this::processService);
    }

    private void processService(Service.Messaging service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"messaging"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("model", (Object)service.subscriptionModel().name()).add("request", (Object)this.processRequests(service.requestList(), service.context(), service.subscriptionModel().name()));
        if (!service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        Commons.writeFrame(this.gen(Target.Server), this.nameOf(service), this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.gen(Target.Server), this.nameOf(service)).getAbsolutePath()));
    }

    private String nameOf(Service.Messaging service) {
        return ((Formatter)StringFormatters.get((Locale)Locale.getDefault()).get("firstuppercase")).format((Object)service.name$()).toString() + "Service";
    }

    private Frame[] processRequests(List<Service.Messaging.Request> requests, String domain, String subscriptionModel) {
        return (Frame[])requests.stream().map(request -> this.processRequest((Service.Messaging.Request)((Object)request), domain, subscriptionModel)).toArray(Frame[]::new);
    }

    private Frame processRequest(Service.Messaging.Request request, String context, String subscriptionModel) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("package", (Object)this.packageName()).add("model", (Object)subscriptionModel).add("path", (Object)Formatters.customize("path", "service." + context + "." + request.path()));
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new MessagingServiceTemplate());
    }
}

