/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.rules.Language;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Translator
extends Layer
implements Terminal {
    protected Language language;
    protected List<Translation> translationList = new ArrayList<Translation>();

    public Translator(Node node) {
        super(node);
    }

    public Language language() {
        return this.language;
    }

    public Translator language(Language value) {
        this.language = value;
        return this;
    }

    public List<Translation> translationList() {
        return Collections.unmodifiableList(this.translationList);
    }

    public Translation translation(int index) {
        return this.translationList.get(index);
    }

    public List<Translation> translationList(Predicate<Translation> predicate) {
        return this.translationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Translation translation(Predicate<Translation> predicate) {
        return this.translationList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Translation>(this.translationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("language", new ArrayList<Language>(Collections.singletonList(this.language)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Translator$Translation")) {
            this.translationList.add((Translation)node.as(Translation.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Translator$Translation")) {
            this.translationList.remove(node.as(Translation.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("language")) {
            this.language = (Language)((Object)WordLoader.load(values, Language.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("language")) {
            this.language = (Language)((Object)values.get(0));
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Translation
    extends Layer
    implements Terminal {
        protected String text;
        protected String value;

        public Translation(Node node) {
            super(node);
        }

        public String text() {
            return this.text;
        }

        public String value() {
            return this.value;
        }

        public Translation text(String value) {
            this.text = value;
            return this;
        }

        public Translation value(String value) {
            this.value = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("text", new ArrayList<String>(Collections.singletonList(this.text)));
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("text")) {
                this.text = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("text")) {
                this.text = (String)values.get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Translation translation(String text, String value) {
            Translation newElement = (Translation)Translator.this.core$().graph().concept(Translation.class).createNode(this.name, Translator.this.core$()).as(Translation.class);
            newElement.core$().set((Layer)newElement, "text", Collections.singletonList(text));
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }
    }

    public class Clear {
        public void translation(Predicate<Translation> filter) {
            new ArrayList<Translation>(Translator.this.translationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

