/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.utils;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FileHelper {
    public static void copyResourcesRecursively(URL originUrl, File destination) {
        try {
            URLConnection urlConnection = originUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                FileHelper.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
            } else {
                FileUtils.copyFile((File)new File(originUrl.getPath()), (File)destination);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> list = jarFile.entries();
        while (list.hasMoreElements()) {
            JarEntry entry = list.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)entryInputStream, (File)new File(destination, fileName));
                    continue;
                }
                finally {
                    if (entryInputStream != null) {
                        entryInputStream.close();
                    }
                    continue;
                }
            }
            new File(destination, fileName).exists();
        }
    }
}

