/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class CategoricalAxisTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("axis"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".analytic.axes;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".analytic.Axis;\n\nimport java.util.*;\nimport java.util.stream.Stream;\nimport java.util.function.Predicate;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" implements Axis {\n\n\tpublic static final String TITLE = \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\n\tpublic static final Component NA = new Component(0, \"NA\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("include", new String[]{"defaultValue"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(");\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("component", new String[0]).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n\tprivate static final class Singleton {\n\t\tprivate static final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" INSTANCE = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("();\n\t}\n\n\t// === STATIC METHODS === //\n\n\tpublic static ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" get() {\n\t\treturn Singleton.INSTANCE;\n\t}\n\n\tpublic static String title() {\n\t\treturn TITLE;\n\t}\n\n\tpublic static int size() {\n\t\treturn get().getSize();\n\t}\n\n\tpublic static List<Component> components() {\n\t\treturn get().getComponents();\n\t}\n\n\tpublic static Stream<Component> stream() {\n\t\treturn get().toStream();\n\t}\n\n\tpublic static List<Component> components(Predicate<Component> filter) {\n\t\treturn get().getComponents(filter);\n\t}\n\n\tpublic static Component component(int index) {\n\t\treturn get().getComponent(index);\n\t}\n\n\tpublic static Component component(String name) {\n\t\treturn get().getComponent(name);\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("include", new String[]{"staticGetter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t// === === //\n\n\tprivate final Component[] components;\n\tprivate final Map<String, Component> componentsByName;\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("components", new String[]{"load"})})}).output(new Rule.Output[]{this.literal("\n\t\tthis.componentsByName = toStream().collect(Collectors.toMap(Component::id, Function.identity()));\n\t}\n\n\t@Override\n\tpublic String getTitle() {\n\t\treturn TITLE;\n\t}\n\n\t@Override\n\tpublic int getSize() {\n\t\treturn components.length;\n\t}\n\n\t/**\n\t* Get all components of this axis as a list, without the NA component (Starts with the component of index 1).\n\t*/\n\t@Override\n\tpublic List<Component> getComponents() {\n\t\treturn new AbstractList<>() {\n\t\t\t@Override\n\t\t\tpublic Component get(int index) {\n\t\t\t\treturn component(index + 1);\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic int size() {\n\t\t\t\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".size() - 1;\n\t\t\t}\n\t\t};\n\t}\n\n\t/**\n\t* Get all components of this axis as a stream, without the NA component (Starts with the component of index 1).\n\t*/\n\t@Override\n\tpublic Stream<Component> toStream() {\n\t\treturn Arrays.stream(components).skip(1);\n\t}\n\n\tpublic List<Component> getComponents(Predicate<Component> filter) {\n\t\treturn stream().filter(filter).collect(Collectors.toList());\n\t}\n\n\t@Override\n\tpublic Component getComponent(int index) {\n\t\tif(index < 0 || index >= components.length) return NA;\n\t\treturn components[index];\n\t}\n\n\t@Override\n\tpublic Component getComponent(String name) {\n\t\treturn componentsByName.getOrDefault(name, NA);\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\";\n\t}\n\n\n\tpublic static class Component implements Axis.Component {\n\n\t\tprivate final int index;\n\t\tprivate final String id;\n\t\t")}).output(new Rule.Output[]{this.mark("include", new String[]{"declaration"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\t\tComponent(int index, String id")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("include", new String[]{"parameter"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(") {\n\t\t\tthis.index = index;\n\t\t\tthis.id = id;\n\t\t\t")}).output(new Rule.Output[]{this.mark("include", new String[]{"assign"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t}\n\n\t\t@Override\n\t\tpublic int index() {\n\t\t\treturn index;\n\t\t}\n\n\t\t@Override\n\t\tpublic String id() {\n\t\t\treturn id;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("include", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\t@Override\n\t\tpublic Axis axis() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".get();\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (this == o) return true;\n\t\t\tif (o == null || getClass() != o.getClass()) return false;\n\t\t\tComponent component = (Component) o;\n\t\t\treturn index == component.index;\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(index, id);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn id;\n\t\t}\n\t}\n}")}), this.rule().condition(this.type("component"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static final Component ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" = new Component(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("id", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\"")})}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("include", new String[]{"constructor"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("declaration")}).output(new Rule.Output[]{this.literal("private final String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("include"), new Rule.Condition[]{this.attribute("name", "label"), this.trigger("staticgetter")}).output(new Rule.Output[]{this.literal("public static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component componentByLabel(String label) {\n\treturn stream().filter(c -> c.label().equals(label)).findFirst().orElse(NA);\n}")}), this.rule().condition(this.type("include"), new Rule.Condition[]{this.attribute("type", "continuous"), this.trigger("staticgetter")}).output(new Rule.Output[]{this.literal("public static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component componentBy")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range range) {\n\treturn stream().filter(c -> c.")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().equals(range)).findFirst().orElse(NA);\n}")}), this.rule().condition(this.type("include"), new Rule.Condition[]{this.attribute("type", "categorical"), this.trigger("staticgetter")}).output(new Rule.Output[]{this.literal("public static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component componentBy")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component component) {\n\treturn stream().filter(c -> c.")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().equals(component)).findFirst().orElse(NA);\n}")}), this.rule().condition(this.type("include"), new Rule.Condition[]{this.attribute("type", "continuous"), this.trigger("declaration")}).output(new Rule.Output[]{this.literal("private final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("include"), new Rule.Condition[]{this.attribute("type", "categorical"), this.trigger("declaration")}).output(new Rule.Output[]{this.literal("private final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[]{this.attribute("type", "continuous")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[]{this.attribute("type", "categorical")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.trigger("tostring"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("sb.append(\", ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("=\").append(")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("defaultvalue")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("id", new String[0])}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.trigger("defaultvalue"), new Rule.Condition[]{this.attribute("type", "categorical")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".NA")}), this.rule().condition(this.trigger("defaultvalue"), new Rule.Condition[]{this.attribute("type", "continuous")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".component(0)")}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("parameter")}).output(new Rule.Output[]{this.literal("String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.attribute("type", "categorical"), new Rule.Condition[]{this.trigger("parameter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.attribute("type", "continuous"), new Rule.Condition[]{this.trigger("parameter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.attribute("name", "label"), new Rule.Condition[]{this.trigger("constructorfromtsv")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] : \"NA\"")}), this.rule().condition(this.trigger("constructorfromtsv"), new Rule.Condition[]{this.attribute("type", "continuous")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".rangeOf(Double.parseDouble(l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("])) : ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".component(0)")}), this.rule().condition(this.trigger("constructorfromtsv"), new Rule.Condition[]{this.attribute("type", "categorical")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".component(l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("]) : ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".NA")}), this.rule().condition(this.trigger("constructor"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".component(\"")}).output(new Rule.Output[]{this.mark("id", new String[0])}).output(new Rule.Output[]{this.literal("\")")}), this.rule().condition(this.trigger("assign"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("this.")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = ")}).output(new Rule.Output[]{this.mark("label", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.trigger("put"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("components.put(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");\ncomponentsByName.put(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.trigger("field"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static final Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" = new Component(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\"")})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.type("components"), new Rule.Condition[]{this.attribute("embedded", "true"), this.trigger("load")}).output(new Rule.Output[]{this.literal("this.components = new Component[] {NA")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("component", new String[0]).multiple(", ")})}).output(new Rule.Output[]{this.literal("};")}), this.rule().condition(this.type("components"), new Rule.Condition[]{this.attribute("embedded", "false"), this.trigger("load")}).output(new Rule.Output[]{this.literal("Component[] components = new Component[0];\njava.io.InputStream resource = getClass().getResourceAsStream(\"")}).output(new Rule.Output[]{this.mark("resource", new String[0])}).output(new Rule.Output[]{this.literal("\");\nif(resource == null) throw new IllegalStateException(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(": Resource \" + \"")}).output(new Rule.Output[]{this.mark("resource", new String[0])}).output(new Rule.Output[]{this.literal("\" + \" not found\");\ntry (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(resource))) {\n\t\tcomponents = Stream.concat(Stream.of(NA),\n\t\treader.lines().map(l -> l.split(\"\t\")).map(l -> new Component(Integer.parseInt(l[0]),l[1]")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(",")}).output(new Rule.Output[]{this.mark("include", new String[]{"constructorFromTsv"}).multiple(", ")})}).output(new Rule.Output[]{this.literal("))\n\t\t).toArray(Component[]::new);\n\t} catch (Exception e) {\n\t\tio.intino.alexandria.logger.Logger.error(\"Failed to load components of ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("\", e);\n\t}\n\tthis.components = components;")})});
    }
}

