/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.ServerRendererWriter;
import io.intino.konos.builder.codegeneration.services.ui.ServiceRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.RendererWriter;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayListRenderer;
import io.intino.konos.builder.codegeneration.ui.resource.ResourceListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import java.io.File;
import java.util.stream.Collectors;

public class ServiceListRenderer
extends UIRenderer {
    private final KonosGraph graph;

    public ServiceListRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.graph = graph;
    }

    @Override
    public void render() throws KonosException {
        for (Service service : this.graph.serviceList(Service::isUI).collect(Collectors.toList())) {
            this.processUIService(service.asUI());
        }
        new ResourceListRenderer(this.context, this.graph, Target.Server).execute();
    }

    private void processUIService(Service.UI service) throws KonosException {
        this.context.serviceDirectory(new File(this.context.configuration().moduleDirectory().getParentFile(), Formatters.camelCaseToSnakeCase().format((Object)service.name$()).toString()));
        new ServiceRenderer(this.context, service).execute();
        new DisplayListRenderer(this.context, service, this.writer()).execute();
    }

    private RendererWriter writer() {
        return new ServerRendererWriter(this.context);
    }
}

