/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components.other;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.ui.RendererWriter;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.model.VisualizationComponents;

public class AppDirectoryRenderer
extends ComponentRenderer<VisualizationComponents.AppDirectory> {
    public AppDirectoryRenderer(CompilationContext compilationContext, VisualizationComponents.AppDirectory component, RendererWriter provider) {
        super(compilationContext, component, provider);
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        result.add("icon", (Object)((VisualizationComponents.AppDirectory)this.element).materialIcon());
        this.addSource(result);
        return result;
    }

    private void addSource(FrameBuilder builder) {
        VisualizationComponents.AppDirectory.Source source = ((VisualizationComponents.AppDirectory)this.element).source();
        this.addFromFileAspect(builder, source);
        this.addFromResourceAspect(builder, source);
        this.addInlineAspect(builder, source);
    }

    private void addFromFileAspect(FrameBuilder builder, VisualizationComponents.AppDirectory.Source source) {
        if (!source.isFromFile()) {
            return;
        }
        builder.add("fromFile");
        VisualizationComponents.AppDirectory.Source.FromFile origin = source.asFromFile();
        if (origin.file() != null && !origin.file().isEmpty()) {
            builder.add("source", (Object)this.fileMethodFrame("source", origin.file()).add("extraParam", (Object)this.clean(origin.separator())));
        }
    }

    private String clean(String separator) {
        return separator.replace("\\\\", "\\");
    }

    private void addFromResourceAspect(FrameBuilder builder, VisualizationComponents.AppDirectory.Source source) {
        if (!source.isFromResource()) {
            return;
        }
        builder.add("fromResource");
        VisualizationComponents.AppDirectory.Source.FromResource origin = source.asFromResource();
        if (origin.path() != null && !origin.path().isEmpty()) {
            builder.add("source", (Object)this.resourceMethodFrame("source", origin.path()).add("extraParam", (Object)this.clean(origin.separator())));
        }
    }

    private void addInlineAspect(FrameBuilder builder, VisualizationComponents.AppDirectory.Source source) {
        if (!source.isInline()) {
            return;
        }
        builder.add("inline");
        VisualizationComponents.AppDirectory.Source.Inline origin = source.asInline();
        origin.applicationList().forEach(a -> builder.add("application", (Object)this.applicationFrame((VisualizationComponents.AppDirectory.Source.Inline.Application)((Object)a))));
    }

    private FrameBuilder applicationFrame(VisualizationComponents.AppDirectory.Source.Inline.Application application) {
        FrameBuilder result = new FrameBuilder(new String[]{"appDirectoryApplication"});
        result.add("name", (Object)application.name());
        result.add("url", (Object)application.url());
        application.translationList().forEach(t -> result.add("translation", this.translationFrame(application, (VisualizationComponents.AppDirectory.Source.Inline.Application.Translation)((Object)t))));
        return result;
    }

    private Object translationFrame(VisualizationComponents.AppDirectory.Source.Inline.Application application, VisualizationComponents.AppDirectory.Source.Inline.Application.Translation translation) {
        FrameBuilder result = new FrameBuilder(new String[]{"appDirectoryApplicationTranslation"});
        result.add("language", (Object)translation.language());
        result.add("name", (Object)translation.name());
        return result;
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("appDirectory", "");
    }
}

