/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.agenda;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.agenda.AgendaServiceTemplate;
import io.intino.konos.builder.codegeneration.services.agenda.FutureRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Data;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Service;
import java.util.List;
import java.util.stream.IntStream;

public class AgendaServiceRenderer
extends Renderer {
    private final List<Service.Agenda> agendas;

    public AgendaServiceRenderer(CompilationContext context, KonosGraph graph) {
        super(context);
        this.agendas = graph.agendaServiceList();
    }

    @Override
    protected void render() throws KonosException {
        if (!this.agendas.isEmpty()) {
            this.render(this.agendas.get(0));
        }
    }

    private void render(Service.Agenda agenda) throws KonosException {
        FrameBuilder builder = new FrameBuilder(new String[]{"agenda", "service"}).add("package", (Object)this.packageName()).add("box", (Object)this.boxName()).add("rootPath", (Object)Commons.fileFrame(agenda.filePath(), this.packageName(), this.context.archetypeQN())).add("baseUri", (Object)agenda.baseUri()).add("future", (Object)this.processFutures(agenda.futureList()));
        if (!agenda.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        Commons.writeFrame(this.gen(Target.Server), "AgendaService", this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(agenda), Commons.javaFile(this.gen(Target.Server), "AgendaService").getAbsolutePath()));
        for (Service.Agenda.Future future : agenda.futureList()) {
            new FutureRenderer(this.context, future).render();
        }
    }

    private Frame[] processFutures(List<Service.Agenda.Future> futureList) {
        return (Frame[])futureList.stream().map(this::frameOf).map(FrameBuilder::toFrame).toArray(Frame[]::new);
    }

    private FrameBuilder frameOf(Service.Agenda.Future f) {
        FrameBuilder builder = new FrameBuilder(new String[]{"future"}).add("name", (Object)f.name$()).add("parameter", (Object)this.framesOf(f.parameterList())).add("option", f.optionList().stream().map(option -> this.frameOf((Service.Agenda.Future.Option)((Object)option), this.framesOf(f.parameterList()))).toArray(Frame[]::new));
        if (!f.optionList().isEmpty()) {
            builder.add("hasOption", (Object)"true");
        }
        return builder;
    }

    private Frame frameOf(Service.Agenda.Future.Option option, Frame[] parameters) {
        return new FrameBuilder(new String[]{"option"}).add("name", (Object)option.name$()).add("future", (Object)option.core$().owner().name()).add("parameter", (Object)parameters).add("optionParameter", (Object)this.framesOf(option.parameterList())).toFrame();
    }

    private Frame[] framesOf(List<Parameter> parameters) {
        return (Frame[])IntStream.range(0, parameters.size()).mapToObj(i -> this.frameOf((Parameter)((Object)((Object)parameters.get(i))), i)).toArray(Frame[]::new);
    }

    private Frame frameOf(Parameter param, int index) {
        String innerPackage = param.isObject() && param.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "";
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter"}).add("index", (Object)index).add("name", (Object)param.name$());
        if (param.isWord()) {
            builder.add("type", (Object)"java.lang.String");
        } else {
            builder.add("type", (Object)(innerPackage + param.asType().type()));
        }
        if (param.i$(Data.List.class)) {
            builder.add("list");
        }
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new AgendaServiceTemplate());
    }
}

