/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.soap;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.soap.SoapServiceTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class SoapServiceRenderer
extends Renderer {
    private final List<Service.Soap> services;
    private final KonosGraph graph;

    public SoapServiceRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.services = graph.serviceList(Service::isSoap).map(Service::asSoap).collect(Collectors.toList());
        this.graph = graph;
    }

    @Override
    public void render() {
        this.services.forEach(service -> this.processService((Service.Soap)service.a$(Service.Soap.class), this.gen(Target.Server)));
    }

    private void processService(Service.Soap service, File gen) {
        if (service.operationList().isEmpty()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"server"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("operation", (Object)this.framesOf(service.operationList()));
        String className = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Service";
        this.classes().put(((Object)((Object)service)).getClass().getSimpleName() + "#" + service.name$(), className);
        Commons.writeFrame(gen, className, this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.gen(Target.Server), className).getAbsolutePath()));
    }

    private Frame[] framesOf(List<Service.Soap.Operation> operations) {
        return (Frame[])operations.stream().map(this::processOperation).toArray(Frame[]::new);
    }

    private Frame processOperation(Service.Soap.Operation operation) {
        return new FrameBuilder(new String[]{"operation"}).add("name", (Object)operation.name$()).add("operation", (Object)((Object)((Object)operation)).getClass().getSimpleName()).add("path", (Object)Formatters.customize("path", Commons.path(operation))).toFrame();
    }

    private Template template() {
        return Formatters.customize(new SoapServiceTemplate());
    }
}

