/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.codegeneration.accessor.AccessorPomTemplate;
import io.intino.konos.builder.context.CompilationContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;

public class PomGenerator {
    private final CompilerConfiguration conf;
    private final CompilationContext context;

    public PomGenerator(CompilationContext context) {
        this.context = context;
        this.conf = context.configuration();
    }

    public void generate(String serviceType, File dir) {
        this.createPom(dir, serviceType, this.context.configuration().groupId().toLowerCase(), dir.getName().split("#")[0], this.context.configuration().version());
    }

    private void createPom(File root, String serviceType, String group, String artifact, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)artifact).add("version", (Object)version);
        if (this.conf.releaseDistributionRepository() != null) {
            this.buildRepoFrame(builder, this.conf.releaseDistributionRepository(), true, false);
        }
        if (this.conf.snapshotDistributionRepository() != null) {
            this.buildRepoFrame(builder, this.conf.snapshotDistributionRepository(), true, true);
        }
        builder.add("dependency", (Object)new FrameBuilder(new String[]{serviceType}).add("value", (Object)"").add("version", (Object)("$" + serviceType)).toFrame());
        File pomFile = new File(root, "pom.xml");
        this.write(builder, pomFile);
    }

    private void write(FrameBuilder builder, File pomFile) {
        try {
            Files.writeString(pomFile.toPath(), (CharSequence)new AccessorPomTemplate().render(builder.toFrame()), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage());
        }
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r, boolean isDistribution, boolean snapshot) {
        builder.add("repository", (Object)this.createRepositoryFrame(r, isDistribution, snapshot));
    }

    private Frame createRepositoryFrame(Configuration.Repository repository, boolean isDistribution, boolean snapshot) {
        FrameBuilder builder = new FrameBuilder(new String[]{"repository"}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url());
        if (isDistribution) {
            builder.add("distribution");
        }
        if (snapshot) {
            builder.add("snapshot");
        }
        return builder.toFrame();
    }
}

