/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.cli;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class CliTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"cli", "service"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.cli.CliManager;\nimport io.intino.alexandria.cli.schemas.BotTalk;\nimport io.intino.alexandria.http.AlexandriaSpark;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("box", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("Service {\n\n    private static ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("ServiceAuthenticator authenticator;\n\n    public static void setup(AlexandriaSpark spark, ")}).output(new Rule.Output[]{this.mark("box", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(" cli) {\n    \tauthenticator = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("ServiceAuthenticator(box);\n        spark.route(\"/cli/")}).output(new Rule.Output[]{this.mark("name", new String[]{"camelCaseToSnakeCase", "lowerCase"})}).output(new Rule.Output[]{this.literal("\")\n                .before(manager -> { if (manager.fromHeader(\"Authorization\") == null || !authenticator.isAuthenticated(manager.fromHeader(\"Authorization\").replace(\"Bearer \", \"\"))) throw new io.intino.alexandria.exceptions.Unauthorized(\"Credential not found\");})\n                .post(manager -> manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(new CliManager(cli, io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromFormAsString(\"talk\"), BotTalk.class)).execute(manager.fromHeader(\"Authorization\").replace(\"Bearer \", \"\")))));\n    }\n}")}), this.rule().condition(this.allTypes(new String[]{"cli", "authenticator"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(";\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "SnakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("ServiceAuthenticator {\n \tprivate ")}).output(new Rule.Output[]{this.mark("box", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box;\n\n \tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "SnakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("ServiceAuthenticator(")}).output(new Rule.Output[]{this.mark("box", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box) {\n\t\tthis.box = box;\n\t}\n\n\tpublic boolean isAuthenticated(String token) {\n\t\treturn false;\n\t}\n}")}), this.rule().condition(this.type("cli"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.cli.Cli;\nimport io.intino.alexandria.cli.command.MessageProperties;\nimport io.intino.alexandria.cli.response.Text;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".cli.commands.*;\n\nimport java.io.IOException;\nimport java.util.Arrays;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\nimport static java.util.Collections.emptyList;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(" extends Cli {\n\n    public ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("box", new String[]{"validname", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box) {\n        super();\n        add(\"help\", \"h\", \"Show this help\", emptyList(), emptyList(), \"\", (properties, command, args) -> new Text(help(properties)));\n        ")}).output(new Rule.Output[]{this.mark("command", new String[0]).multiple("\n")}).output(new Rule.Output[]{this.literal("\n        ")}).output(new Rule.Output[]{this.mark("confirmation", new String[0]).multiple("\n")}).output(new Rule.Output[]{this.literal("\n    }\n\n    @Override\n    protected String initialState() {\n        return \"")}).output(new Rule.Output[]{this.mark("initialState", new String[0])}).output(new Rule.Output[]{this.literal("\";\n    }\n\n    private String help(MessageProperties properties) {\n        return this.commandsInfoByState(contexts().get(properties.token()).state()).keySet().stream()\n                .map((c) -> new StringBuilder().append(formatCommand(c, this.commandsInfoByState(contexts().get(properties.token()).state()).get(c))))\n                .collect(Collectors.joining(\"\\n\"));\n    }\n\n    private static String formatCommand(String command, CommandInfo info) {\n        return \"`\" + command.substring(command.lastIndexOf(\"$\") + 1) + \"|\" + info.abbr() + helpParameters(info.parameters()) + \"` \" + info.description();\n    }\n\n    private static String helpParameters(List<String> parameters) {\n        return parameters.isEmpty() ? \"\" : \" <\" + String.join(\"> <\", parameters) + \">\";\n    }\n}")}), this.rule().condition(this.type("confirmation"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("addQuestionOption(\"")}).output(new Rule.Output[]{this.mark("option", new String[0])}).output(new Rule.Output[]{this.literal("\", (properties, command, args) -> new ")}).output(new Rule.Output[]{this.mark("option", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Command(box).execute(properties, command, args));")}), this.rule().condition(this.type("command"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("add(\"")}).output(new Rule.Output[]{this.mark("command", new String[0])}).output(new Rule.Output[]{this.literal("\", \"")}).output(new Rule.Output[]{this.mark("abbreviation", new String[0])}).output(new Rule.Output[]{this.literal("\", \"")}).output(new Rule.Output[]{this.mark("description", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("parameters", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("preconditions", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("postcondition", new String[0])}).output(new Rule.Output[]{this.literal("\", (properties, command, args) -> new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Command(box).execute(properties, command, args));")}), this.rule().condition(this.allTypes(new String[]{"list", "empty"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("emptyList()")}), this.rule().condition(this.type("list"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("List.of(\"")}).output(new Rule.Output[]{this.mark("item", new String[0]).multiple("\", \"")}).output(new Rule.Output[]{this.literal("\")")})});
    }
}

