/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.slack;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.compiler.shared.PostCompileMethodActionMessage;
import io.intino.konos.model.Service;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

class BotActionsUpdater {
    private final CompilationContext compilationContext;
    private final File destination;
    private final List<? extends Service.SlackBot.Request> requests;

    BotActionsUpdater(CompilationContext compilationContext, File destination, List<? extends Service.SlackBot.Request> requests) {
        this.compilationContext = compilationContext;
        this.destination = destination;
        this.requests = requests;
    }

    void update() {
        this.requests.forEach(this::addMethod);
    }

    private void addMethod(Service.SlackBot.Request request) {
        this.compilationContext.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileMethodActionMessage(this.compilationContext.module(), this.destination, Formatters.firstLowerCase(Formatters.snakeCaseToCamelCase().format((Object)request.name$()).toString()), false, this.parameters(request), "String"));
    }

    private List<String> parameters(Service.SlackBot.Request request) {
        return request.parameterList().stream().map(p -> p.type().name() + (p.multiple() ? "[]" : "") + " " + p.name$()).collect(Collectors.toList());
    }
}

