/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.rest;

import io.intino.konos.model.Exception;
import io.intino.konos.model.Konos;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Response;
import io.intino.konos.model.Schema;
import io.intino.konos.model.Service;
import io.intino.konos.model.bool.BoolData;
import io.intino.konos.model.date.DateData;
import io.intino.konos.model.datetime.DateTimeData;
import io.intino.konos.model.file.FileData;
import io.intino.konos.model.integer.IntegerData;
import io.intino.konos.model.list.ListData;
import io.intino.konos.model.longinteger.LongIntegerData;
import io.intino.konos.model.object.ObjectData;
import io.intino.konos.model.real.RealData;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.konos.model.text.TextData;
import io.intino.konos.model.type.TypeData;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.ResourceLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class RESTService
extends Layer
implements Terminal {
    protected String swagger;
    protected String host;
    protected String description;
    protected String basePath;
    protected List<Protocols> protocols = new ArrayList<Protocols>();
    protected Authenticated authenticated;
    protected AuthenticatedWithCertificate authenticatedWithCertificate;
    protected AuthenticatedWithPassword authenticatedWithPassword;
    protected Info info;
    protected List<Tag> tagList = new ArrayList<Tag>();
    protected List<Resource> resourceList = new ArrayList<Resource>();
    protected Service _service;

    public RESTService(Node node) {
        super(node);
    }

    public String swagger() {
        return this.swagger;
    }

    public String host() {
        return this.host;
    }

    public String description() {
        return this.description;
    }

    public String basePath() {
        return this.basePath;
    }

    public List<Protocols> protocols() {
        return this.protocols;
    }

    public void swagger(String value) {
        this.swagger = value;
    }

    public void host(String value) {
        this.host = value;
    }

    public void description(String value) {
        this.description = value;
    }

    public void basePath(String value) {
        this.basePath = value;
    }

    public Authenticated authenticated() {
        return this.authenticated;
    }

    public AuthenticatedWithCertificate authenticatedWithCertificate() {
        return this.authenticatedWithCertificate;
    }

    public AuthenticatedWithPassword authenticatedWithPassword() {
        return this.authenticatedWithPassword;
    }

    public Info info() {
        return this.info;
    }

    public List<Tag> tagList() {
        return Collections.unmodifiableList(this.tagList);
    }

    public Tag tag(int index) {
        return this.tagList.get(index);
    }

    public List<Tag> tagList(Predicate<Tag> predicate) {
        return this.tagList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Resource> resourceList() {
        return Collections.unmodifiableList(this.resourceList);
    }

    public Resource resource(int index) {
        return this.resourceList.get(index);
    }

    public List<Resource> resourceList(Predicate<Resource> predicate) {
        return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    public void authenticated(Authenticated value) {
        this.authenticated = value;
    }

    public void authenticatedWithCertificate(AuthenticatedWithCertificate value) {
        this.authenticatedWithCertificate = value;
    }

    public void authenticatedWithPassword(AuthenticatedWithPassword value) {
        this.authenticatedWithPassword = value;
    }

    public void info(Info value) {
        this.info = value;
    }

    public List<Node> componentList() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
        if (this.authenticated != null) {
            components.add(this.authenticated.node());
        }
        if (this.authenticatedWithCertificate != null) {
            components.add(this.authenticatedWithCertificate.node());
        }
        if (this.authenticatedWithPassword != null) {
            components.add(this.authenticatedWithPassword.node());
        }
        if (this.info != null) {
            components.add(this.info.node());
        }
        this.tagList.stream().forEach(c -> components.add(c.node()));
        this.resourceList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("swagger", new ArrayList<String>(Collections.singletonList(this.swagger)));
        map.put("host", new ArrayList<String>(Collections.singletonList(this.host)));
        map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
        map.put("basePath", new ArrayList<String>(Collections.singletonList(this.basePath)));
        map.put("protocols", this.protocols);
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Service.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("REST#Service$Authenticated")) {
            this.authenticated = (Authenticated)node.as(Authenticated.class);
        }
        if (node.is("REST#Service$AuthenticatedWithCertificate")) {
            this.authenticatedWithCertificate = (AuthenticatedWithCertificate)node.as(AuthenticatedWithCertificate.class);
        }
        if (node.is("REST#Service$AuthenticatedWithPassword")) {
            this.authenticatedWithPassword = (AuthenticatedWithPassword)node.as(AuthenticatedWithPassword.class);
        }
        if (node.is("REST#Service$Info")) {
            this.info = (Info)node.as(Info.class);
        }
        if (node.is("REST#Service$Tag")) {
            this.tagList.add((Tag)node.as(Tag.class));
        }
        if (node.is("REST#Service$Resource")) {
            this.resourceList.add((Resource)node.as(Resource.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("REST#Service$Authenticated")) {
            this.authenticated = null;
        }
        if (node.is("REST#Service$AuthenticatedWithCertificate")) {
            this.authenticatedWithCertificate = null;
        }
        if (node.is("REST#Service$AuthenticatedWithPassword")) {
            this.authenticatedWithPassword = null;
        }
        if (node.is("REST#Service$Info")) {
            this.info = null;
        }
        if (node.is("REST#Service$Tag")) {
            this.tagList.remove(node.as(Tag.class));
        }
        if (node.is("REST#Service$Resource")) {
            this.resourceList.remove(node.as(Resource.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("swagger")) {
            this.swagger = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("host")) {
            this.host = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("basePath")) {
            this.basePath = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("protocols")) {
            this.protocols = WordLoader.load(values, Protocols.class, (Layer)this);
        }
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("swagger")) {
            this.swagger = (String)values.get(0);
        } else if (name.equalsIgnoreCase("host")) {
            this.host = (String)values.get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)values.get(0);
        } else if (name.equalsIgnoreCase("basePath")) {
            this.basePath = (String)values.get(0);
        } else if (name.equalsIgnoreCase("protocols")) {
            this.protocols = new ArrayList(values);
        }
    }

    protected void _sync(Layer layer) {
        super._sync(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Resource
    extends Layer
    implements Terminal {
        protected String path;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Operation> operationList = new ArrayList<Operation>();
        protected List<Get> getList = new ArrayList<Get>();
        protected List<Post> postList = new ArrayList<Post>();
        protected List<Put> putList = new ArrayList<Put>();
        protected List<Delete> deleteList = new ArrayList<Delete>();
        protected List<Head> headList = new ArrayList<Head>();
        protected List<Options> optionsList = new ArrayList<Options>();
        protected List<Patch> patchList = new ArrayList<Patch>();

        public Resource(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public void path(String value) {
            this.path = value;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Get> getList() {
            return Collections.unmodifiableList(this.getList);
        }

        public Get get(int index) {
            return this.getList.get(index);
        }

        public List<Get> getList(Predicate<Get> predicate) {
            return this.getList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Post> postList() {
            return Collections.unmodifiableList(this.postList);
        }

        public Post post(int index) {
            return this.postList.get(index);
        }

        public List<Post> postList(Predicate<Post> predicate) {
            return this.postList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Put> putList() {
            return Collections.unmodifiableList(this.putList);
        }

        public Put put(int index) {
            return this.putList.get(index);
        }

        public List<Put> putList(Predicate<Put> predicate) {
            return this.putList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Delete> deleteList() {
            return Collections.unmodifiableList(this.deleteList);
        }

        public Delete delete(int index) {
            return this.deleteList.get(index);
        }

        public List<Delete> deleteList(Predicate<Delete> predicate) {
            return this.deleteList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Head> headList() {
            return Collections.unmodifiableList(this.headList);
        }

        public Head head(int index) {
            return this.headList.get(index);
        }

        public List<Head> headList(Predicate<Head> predicate) {
            return this.headList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Options> optionsList() {
            return Collections.unmodifiableList(this.optionsList);
        }

        public Options options(int index) {
            return this.optionsList.get(index);
        }

        public List<Options> optionsList(Predicate<Options> predicate) {
            return this.optionsList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Patch> patchList() {
            return Collections.unmodifiableList(this.patchList);
        }

        public Patch patch(int index) {
            return this.patchList.get(index);
        }

        public List<Patch> patchList(Predicate<Patch> predicate) {
            return this.patchList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.parameterList.stream().forEach(c -> components.add(c.node()));
            this.operationList.stream().forEach(c -> components.add(c.node()));
            this.getList.stream().forEach(c -> components.add(c.node()));
            this.postList.stream().forEach(c -> components.add(c.node()));
            this.putList.stream().forEach(c -> components.add(c.node()));
            this.deleteList.stream().forEach(c -> components.add(c.node()));
            this.headList.stream().forEach(c -> components.add(c.node()));
            this.optionsList.stream().forEach(c -> components.add(c.node()));
            this.patchList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Resource.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("REST#Service$Resource$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("REST#Service$Resource$Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
            if (node.is("REST#Service$Resource$Get")) {
                this.getList.add((Get)node.as(Get.class));
            }
            if (node.is("REST#Service$Resource$Post")) {
                this.postList.add((Post)node.as(Post.class));
            }
            if (node.is("REST#Service$Resource$Put")) {
                this.putList.add((Put)node.as(Put.class));
            }
            if (node.is("REST#Service$Resource$Delete")) {
                this.deleteList.add((Delete)node.as(Delete.class));
            }
            if (node.is("REST#Service$Resource$Head")) {
                this.headList.add((Head)node.as(Head.class));
            }
            if (node.is("REST#Service$Resource$Options")) {
                this.optionsList.add((Options)node.as(Options.class));
            }
            if (node.is("REST#Service$Resource$Patch")) {
                this.patchList.add((Patch)node.as(Patch.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("REST#Service$Resource$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("REST#Service$Resource$Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
            if (node.is("REST#Service$Resource$Get")) {
                this.getList.remove(node.as(Get.class));
            }
            if (node.is("REST#Service$Resource$Post")) {
                this.postList.remove(node.as(Post.class));
            }
            if (node.is("REST#Service$Resource$Put")) {
                this.putList.remove(node.as(Put.class));
            }
            if (node.is("REST#Service$Resource$Delete")) {
                this.deleteList.remove(node.as(Delete.class));
            }
            if (node.is("REST#Service$Resource$Head")) {
                this.headList.remove(node.as(Head.class));
            }
            if (node.is("REST#Service$Resource$Options")) {
                this.optionsList.remove(node.as(Options.class));
            }
            if (node.is("REST#Service$Resource$Patch")) {
                this.patchList.remove(node.as(Patch.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public static class Patch
        extends Operation
        implements Terminal {
            public Patch(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Patch.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Operation.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Options
        extends Operation
        implements Terminal {
            public Options(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Options.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Operation.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Head
        extends Operation
        implements Terminal {
            public Head(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Head.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Operation.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Delete
        extends Operation
        implements Terminal {
            public Delete(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Delete.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Operation.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Put
        extends Operation
        implements Terminal {
            public Put(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Put.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Operation.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Post
        extends Operation
        implements Terminal {
            public Post(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Post.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Operation.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Get
        extends Operation
        implements Terminal {
            public Get(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Get.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Operation.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static abstract class Operation
        extends Layer
        implements Terminal {
            protected List<String> tags = new ArrayList<String>();
            protected String summary;
            protected String description;
            protected URL externalDocumentation;
            protected boolean deprecated;
            protected List<Exception> exceptionRefs = new ArrayList<Exception>();
            protected List<Parameter> parameterList = new ArrayList<Parameter>();
            protected Response response;
            protected List<Exception> exceptionList = new ArrayList<Exception>();

            public Operation(Node node) {
                super(node);
            }

            public List<String> tags() {
                return this.tags;
            }

            public String tags(int index) {
                return this.tags.get(index);
            }

            public List<String> tags(Predicate<String> predicate) {
                return this.tags().stream().filter(predicate).collect(Collectors.toList());
            }

            public String summary() {
                return this.summary;
            }

            public String description() {
                return this.description;
            }

            public URL externalDocumentation() {
                return this.externalDocumentation;
            }

            public boolean deprecated() {
                return this.deprecated;
            }

            public List<Exception> exceptionRefs() {
                return this.exceptionRefs;
            }

            public Exception exceptionRefs(int index) {
                return this.exceptionRefs.get(index);
            }

            public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
                return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
            }

            public void summary(String value) {
                this.summary = value;
            }

            public void description(String value) {
                this.description = value;
            }

            public void externalDocumentation(URL url, String destiny) {
                this.externalDocumentation = this.graph().save(url, destiny, this.externalDocumentation, this.node());
            }

            public void externalDocumentation(InputStream stream, String destiny) {
                this.externalDocumentation = this.graph().save(stream, destiny, this.externalDocumentation, this.node());
            }

            public void deprecated(boolean value) {
                this.deprecated = value;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Response response() {
                return this.response;
            }

            public List<Exception> exceptionList() {
                return Collections.unmodifiableList(this.exceptionList);
            }

            public Exception exception(int index) {
                return this.exceptionList.get(index);
            }

            public List<Exception> exceptionList(Predicate<Exception> predicate) {
                return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
            }

            public void response(Response value) {
                this.response = value;
            }

            public List<Node> componentList() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                this.parameterList.stream().forEach(c -> components.add(c.node()));
                if (this.response != null) {
                    components.add(this.response.node());
                }
                this.exceptionList.stream().forEach(c -> components.add(c.node()));
                return new ArrayList<Node>(components);
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("tags", this.tags);
                map.put("summary", new ArrayList<String>(Collections.singletonList(this.summary)));
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("externalDocumentation", new ArrayList<URL>(Collections.singletonList(this.externalDocumentation)));
                map.put("deprecated", new ArrayList<Boolean>(Collections.singletonList(this.deprecated)));
                map.put("exceptionRefs", this.exceptionRefs);
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Operation.class);
            }

            protected void addNode(Node node) {
                super.addNode(node);
                if (node.is("REST#Service$Resource$Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
                if (node.is("Response")) {
                    this.response = (Response)node.as(Response.class);
                }
                if (node.is("Exception")) {
                    this.exceptionList.add((Exception)node.as(Exception.class));
                }
            }

            protected void removeNode(Node node) {
                super.removeNode(node);
                if (node.is("REST#Service$Resource$Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
                if (node.is("Response")) {
                    this.response = null;
                }
                if (node.is("Exception")) {
                    this.exceptionList.remove(node.as(Exception.class));
                }
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("tags")) {
                    this.tags = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("summary")) {
                    this.summary = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("externalDocumentation")) {
                    this.externalDocumentation = (URL)ResourceLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("deprecated")) {
                    this.deprecated = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("exceptionRefs")) {
                    this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("tags")) {
                    this.tags = new ArrayList(values);
                } else if (name.equalsIgnoreCase("summary")) {
                    this.summary = (String)values.get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("externalDocumentation")) {
                    this.externalDocumentation = (URL)values.get(0);
                } else if (name.equalsIgnoreCase("deprecated")) {
                    this.deprecated = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("exceptionRefs")) {
                    this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().loadNode(((Layer)s).id()).as(Exception.class)).collect(Collectors.toList());
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter(Parameter.In in) {
                    Parameter newElement = (Parameter)Operation.this.graph().concept(Parameter.class).createNode(this.name, Operation.this.node()).as(Parameter.class);
                    newElement.node().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Response response() {
                    Response newElement = (Response)Operation.this.graph().concept(Response.class).createNode(this.name, Operation.this.node()).as(Response.class);
                    return newElement;
                }

                public Exception exception(ExceptionCodes code) {
                    Exception newElement = (Exception)Operation.this.graph().concept(Exception.class).createNode(this.name, Operation.this.node()).as(Exception.class);
                    newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
                    return newElement;
                }
            }
        }

        public static class Parameter
        extends io.intino.konos.model.Parameter
        implements Component,
        Terminal {
            protected String description;
            protected In in;

            public Parameter(Node node) {
                super(node);
            }

            public String description() {
                return this.description;
            }

            public In in() {
                return this.in;
            }

            public void description(String value) {
                this.description = value;
            }

            public void in(In value) {
                this.in = value;
            }

            @Override
            public IntegerData asInteger() {
                Layer as = this.as(IntegerData.class);
                return as != null ? (IntegerData)as : (IntegerData)this.addFacet(IntegerData.class);
            }

            @Override
            public boolean isInteger() {
                return this.is(IntegerData.class);
            }

            @Override
            public TypeData asType() {
                return (TypeData)this.as(TypeData.class);
            }

            @Override
            public TypeData asType(Expression<String> type) {
                TypeData newElement = (TypeData)this.addFacet(TypeData.class);
                newElement.node().set((Layer)newElement, "type", Collections.singletonList(type));
                return newElement;
            }

            @Override
            public boolean isType() {
                return this.is(TypeData.class);
            }

            @Override
            public void removeType() {
                this.removeFacet(TypeData.class);
            }

            @Override
            public BoolData asBool() {
                Layer as = this.as(BoolData.class);
                return as != null ? (BoolData)as : (BoolData)this.addFacet(BoolData.class);
            }

            @Override
            public boolean isBool() {
                return this.is(BoolData.class);
            }

            @Override
            public RealData asReal() {
                Layer as = this.as(RealData.class);
                return as != null ? (RealData)as : (RealData)this.addFacet(RealData.class);
            }

            @Override
            public boolean isReal() {
                return this.is(RealData.class);
            }

            @Override
            public LongIntegerData asLongInteger() {
                Layer as = this.as(LongIntegerData.class);
                return as != null ? (LongIntegerData)as : (LongIntegerData)this.addFacet(LongIntegerData.class);
            }

            @Override
            public boolean isLongInteger() {
                return this.is(LongIntegerData.class);
            }

            @Override
            public TextData asText() {
                Layer as = this.as(TextData.class);
                return as != null ? (TextData)as : (TextData)this.addFacet(TextData.class);
            }

            @Override
            public boolean isText() {
                return this.is(TextData.class);
            }

            @Override
            public ObjectData asObject() {
                return (ObjectData)this.as(ObjectData.class);
            }

            @Override
            public ObjectData asObject(Schema schema) {
                ObjectData newElement = (ObjectData)this.addFacet(ObjectData.class);
                newElement.node().set((Layer)newElement, "schema", Collections.singletonList(schema));
                return newElement;
            }

            @Override
            public boolean isObject() {
                return this.is(ObjectData.class);
            }

            @Override
            public void removeObject() {
                this.removeFacet(ObjectData.class);
            }

            @Override
            public ListData asList() {
                Layer as = this.as(ListData.class);
                return as != null ? (ListData)as : (ListData)this.addFacet(ListData.class);
            }

            @Override
            public boolean isList() {
                return this.is(ListData.class);
            }

            @Override
            public FileData asFile() {
                Layer as = this.as(FileData.class);
                return as != null ? (FileData)as : (FileData)this.addFacet(FileData.class);
            }

            @Override
            public boolean isFile() {
                return this.is(FileData.class);
            }

            @Override
            public DateData asDate() {
                Layer as = this.as(DateData.class);
                return as != null ? (DateData)as : (DateData)this.addFacet(DateData.class);
            }

            @Override
            public boolean isDate() {
                return this.is(DateData.class);
            }

            @Override
            public DateTimeData asDateTime() {
                Layer as = this.as(DateTimeData.class);
                return as != null ? (DateTimeData)as : (DateTimeData)this.addFacet(DateTimeData.class);
            }

            @Override
            public boolean isDateTime() {
                return this.is(DateTimeData.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("in", new ArrayList<In>(Collections.singletonList(this.in)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Parameter.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("in")) {
                    this.in = (In)((Object)WordLoader.load(values, In.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("in")) {
                    this.in = (In)((Object)values.get(0));
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends io.intino.konos.model.Parameter$Create {
                public Create(String name) {
                    super(name);
                }
            }

            public static enum In {
                body,
                path,
                form,
                header,
                query;

            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter(Parameter.In in) {
                Parameter newElement = (Parameter)Resource.this.graph().concept(Parameter.class).createNode(this.name, Resource.this.node()).as(Parameter.class);
                newElement.node().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }

            public Get get() {
                Get newElement = (Get)Resource.this.graph().concept(Get.class).createNode(this.name, Resource.this.node()).as(Get.class);
                return newElement;
            }

            public Post post() {
                Post newElement = (Post)Resource.this.graph().concept(Post.class).createNode(this.name, Resource.this.node()).as(Post.class);
                return newElement;
            }

            public Put put() {
                Put newElement = (Put)Resource.this.graph().concept(Put.class).createNode(this.name, Resource.this.node()).as(Put.class);
                return newElement;
            }

            public Delete delete() {
                Delete newElement = (Delete)Resource.this.graph().concept(Delete.class).createNode(this.name, Resource.this.node()).as(Delete.class);
                return newElement;
            }

            public Head head() {
                Head newElement = (Head)Resource.this.graph().concept(Head.class).createNode(this.name, Resource.this.node()).as(Head.class);
                return newElement;
            }

            public Options options() {
                Options newElement = (Options)Resource.this.graph().concept(Options.class).createNode(this.name, Resource.this.node()).as(Options.class);
                return newElement;
            }

            public Patch patch() {
                Patch newElement = (Patch)Resource.this.graph().concept(Patch.class).createNode(this.name, Resource.this.node()).as(Patch.class);
                return newElement;
            }
        }
    }

    public static class Tag
    extends Layer
    implements Terminal {
        protected String description;
        protected List<Document> documentList = new ArrayList<Document>();

        public Tag(Node node) {
            super(node);
        }

        public String description() {
            return this.description;
        }

        public void description(String value) {
            this.description = value;
        }

        public List<Document> documentList() {
            return Collections.unmodifiableList(this.documentList);
        }

        public Document document(int index) {
            return this.documentList.get(index);
        }

        public List<Document> documentList(Predicate<Document> predicate) {
            return this.documentList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.documentList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Tag.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("REST#Service$Tag$Document")) {
                this.documentList.add((Document)node.as(Document.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("REST#Service$Tag$Document")) {
                this.documentList.remove(node.as(Document.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public static class Document
        extends Layer
        implements Terminal {
            protected String description;
            protected String url;

            public Document(Node node) {
                super(node);
            }

            public String description() {
                return this.description;
            }

            public String url() {
                return this.url;
            }

            public void description(String value) {
                this.description = value;
            }

            public void url(String value) {
                this.url = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Document.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Document document(String url) {
                Document newElement = (Document)Tag.this.graph().concept(Document.class).createNode(this.name, Tag.this.node()).as(Document.class);
                newElement.node().set((Layer)newElement, "url", Collections.singletonList(url));
                return newElement;
            }
        }
    }

    public static class Info
    extends Layer
    implements Terminal {
        protected String title;
        protected String version;
        protected String description;
        protected String termsOfService;
        protected Contact contact;
        protected License license;

        public Info(Node node) {
            super(node);
        }

        public String title() {
            return this.title;
        }

        public String version() {
            return this.version;
        }

        public String description() {
            return this.description;
        }

        public String termsOfService() {
            return this.termsOfService;
        }

        public void title(String value) {
            this.title = value;
        }

        public void version(String value) {
            this.version = value;
        }

        public void description(String value) {
            this.description = value;
        }

        public void termsOfService(String value) {
            this.termsOfService = value;
        }

        public Contact contact() {
            return this.contact;
        }

        public License license() {
            return this.license;
        }

        public void contact(Contact value) {
            this.contact = value;
        }

        public void license(License value) {
            this.license = value;
        }

        public List<Node> componentList() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
            if (this.contact != null) {
                components.add(this.contact.node());
            }
            if (this.license != null) {
                components.add(this.license.node());
            }
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
            map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            map.put("termsOfService", new ArrayList<String>(Collections.singletonList(this.termsOfService)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Info.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("REST#Service$Info$Contact")) {
                this.contact = (Contact)node.as(Contact.class);
            }
            if (node.is("REST#Service$Info$License")) {
                this.license = (License)node.as(License.class);
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("REST#Service$Info$Contact")) {
                this.contact = null;
            }
            if (node.is("REST#Service$Info$License")) {
                this.license = null;
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("version")) {
                this.version = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("termsOfService")) {
                this.termsOfService = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)values.get(0);
            } else if (name.equalsIgnoreCase("version")) {
                this.version = (String)values.get(0);
            } else if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            } else if (name.equalsIgnoreCase("termsOfService")) {
                this.termsOfService = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public static class License
        extends Layer
        implements Terminal {
            protected String url;

            public License(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public void url(String value) {
                this.url = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(License.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static class Contact
        extends Layer
        implements Terminal {
            protected String url;
            protected String email;

            public Contact(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public String email() {
                return this.email;
            }

            public void url(String value) {
                this.url = value;
            }

            public void email(String value) {
                this.email = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                map.put("email", new ArrayList<String>(Collections.singletonList(this.email)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Contact.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("email")) {
                    this.email = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                } else if (name.equalsIgnoreCase("email")) {
                    this.email = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Contact contact() {
                Contact newElement = (Contact)Info.this.graph().concept(Contact.class).createNode(this.name, Info.this.node()).as(Contact.class);
                return newElement;
            }

            public License license() {
                License newElement = (License)Info.this.graph().concept(License.class).createNode(this.name, Info.this.node()).as(License.class);
                return newElement;
            }
        }
    }

    public static class AuthenticatedWithPassword
    extends Authenticated
    implements Terminal {
        protected List<AllowedUsers> allowedUsersList = new ArrayList<AllowedUsers>();

        public AuthenticatedWithPassword(Node node) {
            super(node);
        }

        public List<AllowedUsers> allowedUsersList() {
            return Collections.unmodifiableList(this.allowedUsersList);
        }

        public AllowedUsers allowedUsers(int index) {
            return this.allowedUsersList.get(index);
        }

        public List<AllowedUsers> allowedUsersList(Predicate<AllowedUsers> predicate) {
            return this.allowedUsersList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.allowedUsersList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(AuthenticatedWithPassword.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("REST#Service$AuthenticatedWithPassword$AllowedUsers")) {
                this.allowedUsersList.add((AllowedUsers)node.as(AllowedUsers.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("REST#Service$AuthenticatedWithPassword$AllowedUsers")) {
                this.allowedUsersList.remove(node.as(AllowedUsers.class));
            }
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public static class AllowedUsers
        extends Layer
        implements Terminal {
            protected String user;
            protected String password;

            public AllowedUsers(Node node) {
                super(node);
            }

            public String user() {
                return this.user;
            }

            public String password() {
                return this.password;
            }

            public void user(String value) {
                this.user = value;
            }

            public void password(String value) {
                this.password = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
                map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(AllowedUsers.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = (String)values.get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create
        extends Authenticated.Create {
            public Create(String name) {
                super(name);
            }

            public AllowedUsers allowedUsers(String user, String password) {
                AllowedUsers newElement = (AllowedUsers)AuthenticatedWithPassword.this.graph().concept(AllowedUsers.class).createNode(this.name, AuthenticatedWithPassword.this.node()).as(AllowedUsers.class);
                newElement.node().set((Layer)newElement, "user", Collections.singletonList(user));
                newElement.node().set((Layer)newElement, "password", Collections.singletonList(password));
                return newElement;
            }
        }
    }

    public static class AuthenticatedWithCertificate
    extends Authenticated
    implements Terminal {
        protected URL store;
        protected String storePassword;
        protected List<AllowedUsers> allowedUsersList = new ArrayList<AllowedUsers>();

        public AuthenticatedWithCertificate(Node node) {
            super(node);
        }

        public URL store() {
            return this.store;
        }

        public String storePassword() {
            return this.storePassword;
        }

        public void store(URL url, String destiny) {
            this.store = this.graph().save(url, destiny, this.store, this.node());
        }

        public void store(InputStream stream, String destiny) {
            this.store = this.graph().save(stream, destiny, this.store, this.node());
        }

        public void storePassword(String value) {
            this.storePassword = value;
        }

        public List<AllowedUsers> allowedUsersList() {
            return Collections.unmodifiableList(this.allowedUsersList);
        }

        public AllowedUsers allowedUsers(int index) {
            return this.allowedUsersList.get(index);
        }

        public List<AllowedUsers> allowedUsersList(Predicate<AllowedUsers> predicate) {
            return this.allowedUsersList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.allowedUsersList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            map.put("store", new ArrayList<URL>(Collections.singletonList(this.store)));
            map.put("storePassword", new ArrayList<String>(Collections.singletonList(this.storePassword)));
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(AuthenticatedWithCertificate.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("REST#Service$AuthenticatedWithCertificate$AllowedUsers")) {
                this.allowedUsersList.add((AllowedUsers)node.as(AllowedUsers.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("REST#Service$AuthenticatedWithCertificate$AllowedUsers")) {
                this.allowedUsersList.remove(node.as(AllowedUsers.class));
            }
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("store")) {
                this.store = (URL)ResourceLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("storePassword")) {
                this.storePassword = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("store")) {
                this.store = (URL)values.get(0);
            } else if (name.equalsIgnoreCase("storePassword")) {
                this.storePassword = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public static class AllowedUsers
        extends Layer
        implements Terminal {
            protected List<URL> certificate = new ArrayList<URL>();

            public AllowedUsers(Node node) {
                super(node);
            }

            public List<URL> certificate() {
                return this.certificate;
            }

            public URL certificate(int index) {
                return this.certificate.get(index);
            }

            public List<URL> certificate(Predicate<URL> predicate) {
                return this.certificate().stream().filter(predicate).collect(Collectors.toList());
            }

            public void addCertificate(URL url, String destiny) {
                URL newElement = this.graph().save(url, destiny, null, this.node());
                this.certificate.add(newElement);
            }

            public void addCertificate(InputStream stream, String destiny) {
                URL newElement = this.graph().save(stream, destiny, null, this.node());
                this.certificate.add(newElement);
            }

            public OutputStream addCertificate(String destiny) {
                URL newElement = this.graph().save((InputStream)null, destiny, null, this.node());
                this.certificate.add(newElement);
                try {
                    return newElement.openConnection().getOutputStream();
                }
                catch (IOException e) {
                    Logger.getGlobal().severe(e.getMessage());
                    return null;
                }
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("certificate", this.certificate);
                return map;
            }

            public Concept concept() {
                return this.graph().concept(AllowedUsers.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("certificate")) {
                    this.certificate = ResourceLoader.load(values, (Layer)this);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("certificate")) {
                    this.certificate = new ArrayList(values);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create
        extends Authenticated.Create {
            public Create(String name) {
                super(name);
            }

            public AllowedUsers allowedUsers(List<URL> certificate) {
                AllowedUsers newElement = (AllowedUsers)AuthenticatedWithCertificate.this.graph().concept(AllowedUsers.class).createNode(this.name, AuthenticatedWithCertificate.this.node()).as(AllowedUsers.class);
                newElement.node().set((Layer)newElement, "certificate", certificate);
                return newElement;
            }
        }
    }

    public static abstract class Authenticated
    extends Layer
    implements Terminal {
        public Authenticated(Node node) {
            super(node);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Authenticated.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public AuthenticatedWithCertificate authenticatedWithCertificate(URL store, String storePassword) {
            AuthenticatedWithCertificate newElement = (AuthenticatedWithCertificate)RESTService.this.graph().concept(AuthenticatedWithCertificate.class).createNode(this.name, RESTService.this.node()).as(AuthenticatedWithCertificate.class);
            newElement.node().set((Layer)newElement, "store", Collections.singletonList(store));
            newElement.node().set((Layer)newElement, "storePassword", Collections.singletonList(storePassword));
            return newElement;
        }

        public AuthenticatedWithPassword authenticatedWithPassword() {
            AuthenticatedWithPassword newElement = (AuthenticatedWithPassword)RESTService.this.graph().concept(AuthenticatedWithPassword.class).createNode(this.name, RESTService.this.node()).as(AuthenticatedWithPassword.class);
            return newElement;
        }

        public Info info(String title, String version) {
            Info newElement = (Info)RESTService.this.graph().concept(Info.class).createNode(this.name, RESTService.this.node()).as(Info.class);
            newElement.node().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Tag tag() {
            Tag newElement = (Tag)RESTService.this.graph().concept(Tag.class).createNode(this.name, RESTService.this.node()).as(Tag.class);
            return newElement;
        }

        public Resource resource(String path) {
            Resource newElement = (Resource)RESTService.this.graph().concept(Resource.class).createNode(this.name, RESTService.this.node()).as(Resource.class);
            newElement.node().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)RESTService.this.graph().concept(Schema.class).createNode(this.name, RESTService.this.node()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)RESTService.this.graph().concept(Exception.class).createNode(this.name, RESTService.this.node()).as(Exception.class);
            newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }

    public static enum Protocols {
        http,
        https,
        ws,
        wss;

    }
}

