/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.swagger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.intino.konos.builder.codegeneration.swagger.SwaggerSpec;
import io.intino.konos.model.Exception;
import io.intino.konos.model.Response;
import io.intino.konos.model.Schema;
import io.intino.konos.model.rest.RESTService;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OpenApiDescriptor {
    private final RESTService restService;
    private final List<Schema> schemas;

    public OpenApiDescriptor(RESTService restService) {
        this.restService = restService;
        this.schemas = restService.graph().find(Schema.class);
    }

    public String createJSONDescriptor() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this.create());
    }

    private SwaggerSpec create() {
        SwaggerSpec spec = new SwaggerSpec();
        spec.basePath = this.restService.basePath();
        spec.definitions = this.createDefinitions();
        spec.host = this.restService.host();
        spec.schemes = this.restService.protocols().stream().map(Enum::name).collect(Collectors.toList());
        spec.paths = new LinkedHashMap<String, SwaggerSpec.Path>();
        spec.info = this.createInfo(this.restService.info());
        for (RESTService.Resource resource : this.restService.resourceList()) {
            spec.paths.put(resource.path(), this.createPath(resource));
        }
        return spec;
    }

    private SwaggerSpec.Info createInfo(RESTService.Info info) {
        return info == null ? null : new SwaggerSpec.Info(info.version(), info.title(), info.description(), info.termsOfService(), info.contact() == null ? null : new SwaggerSpec.Info.Contact(info.contact().name(), info.contact().email(), info.contact().url()), info.license() == null ? null : new SwaggerSpec.Info.License(info.license().name(), info.license().url()));
    }

    private SwaggerSpec.Path createPath(RESTService.Resource resource) {
        SwaggerSpec.Path path = new SwaggerSpec.Path();
        for (RESTService.Resource.Operation op : resource.operationList()) {
            SwaggerSpec.Path.Operation operation = new SwaggerSpec.Path.Operation();
            operation.description = op.description().isEmpty() ? null : op.description();
            operation.summary = op.summary().isEmpty() ? null : op.summary();
            operation.operationId = op.name();
            operation.tags = op.tags().isEmpty() ? null : op.tags();
            operation.parameters = this.createParameters(op.parameterList());
            this.addResponse(operation.responses, op.response());
            this.addResponse(operation.responses, op.exceptionList());
            this.addOperationToPath(path, operation, op.concept().name());
        }
        return path;
    }

    private void addResponse(Map<String, SwaggerSpec.Path.Operation.Response> responses, Response response) {
        SwaggerSpec.Path.Operation.Response swaggerResponse = new SwaggerSpec.Path.Operation.Response();
        swaggerResponse.description = response.description();
        if (response.isObject()) {
            swaggerResponse.schema = new SwaggerSpec.Path.Operation.Response.Schema(null, "#/definitions/" + response.asObject().schema().name());
        }
        responses.put(response.code(), swaggerResponse);
    }

    private void addResponse(Map<String, SwaggerSpec.Path.Operation.Response> responses, List<Exception> exceptions) {
        for (Exception exception : exceptions) {
            SwaggerSpec.Path.Operation.Response swaggerResponse = new SwaggerSpec.Path.Operation.Response();
            swaggerResponse.description = exception.description();
            if (exception.isObject()) {
                swaggerResponse.schema = new SwaggerSpec.Path.Operation.Response.Schema(null, "#/definitions/" + exception.asObject().schema().name());
            }
            responses.put(exception.code().value(), swaggerResponse);
        }
    }

    private void addOperationToPath(SwaggerSpec.Path path, SwaggerSpec.Path.Operation operation, String name) {
        switch (name) {
            case "Get": {
                path.get = operation;
                break;
            }
            case "Post": {
                path.post = operation;
                break;
            }
            case "patch": {
                path.patch = operation;
                break;
            }
            case "Put": {
                path.put = operation;
                break;
            }
            case "Delete": {
                path.delete = operation;
                break;
            }
            default: {
                path.head = operation;
            }
        }
    }

    private List<SwaggerSpec.Path.Operation.Parameter> createParameters(List<RESTService.Resource.Parameter> parameters) {
        ArrayList<SwaggerSpec.Path.Operation.Parameter> list = new ArrayList<SwaggerSpec.Path.Operation.Parameter>();
        for (RESTService.Resource.Parameter parameter : parameters) {
            SwaggerSpec.Path.Operation.Parameter swaggerParameter = new SwaggerSpec.Path.Operation.Parameter();
            swaggerParameter.description = parameter.description();
            swaggerParameter.in = parameter.in().name();
            swaggerParameter.name = parameter.name();
            swaggerParameter.type = parameter.asType().type().toLowerCase();
            swaggerParameter.required = parameter.required();
            list.add(swaggerParameter);
        }
        return list.isEmpty() ? null : list;
    }

    private Map<String, SwaggerSpec.Definition> createDefinitions() {
        LinkedHashMap<String, SwaggerSpec.Definition> map = new LinkedHashMap<String, SwaggerSpec.Definition>();
        for (Schema schema : this.schemas) {
            SwaggerSpec.Definition definition = new SwaggerSpec.Definition();
            definition.required = schema.attributeList().stream().filter(Schema.Attribute::required).map(Layer::name).collect(Collectors.toList());
            definition.properties = this.toMap(schema.attributeList());
            map.put(schema.name(), definition);
        }
        return map;
    }

    private Map<String, SwaggerSpec.Definition.Property> toMap(List<Schema.Attribute> attributes) {
        LinkedHashMap<String, SwaggerSpec.Definition.Property> map = new LinkedHashMap<String, SwaggerSpec.Definition.Property>();
        for (Schema.Attribute attribute : attributes) {
            map.put(attribute.name(), this.propertyFrom(attribute));
        }
        return map;
    }

    @NotNull
    private SwaggerSpec.Definition.Property propertyFrom(Schema.Attribute attribute) {
        SwaggerSpec.Definition.Property property = new SwaggerSpec.Definition.Property();
        property.type = attribute.asType().type().toLowerCase();
        SwaggerSpec.Definition.Property property2 = property;
        if (property2 == null) {
            OpenApiDescriptor.$$$reportNull$$$0(0);
        }
        return property2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/swagger/OpenApiDescriptor", "propertyFrom"));
    }
}

