/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.slackbot;

import io.intino.konos.model.Exception;
import io.intino.konos.model.Konos;
import io.intino.konos.model.Schema;
import io.intino.konos.model.Service;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SlackBotService
extends Layer
implements Terminal {
    protected List<Notification> notificationList = new ArrayList<Notification>();
    protected List<Request> requestList = new ArrayList<Request>();
    protected Service _service;

    public SlackBotService(Node node) {
        super(node);
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.notificationList.stream().forEach(c -> components.add(c.node()));
        this.requestList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Service.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("SlackBot#Service$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
        if (node.is("SlackBot#Service$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("SlackBot#Service$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
        if (node.is("SlackBot#Service$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
    }

    protected void _sync(Layer layer) {
        super._sync(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Request
    extends Layer
    implements Terminal {
        protected String description;
        protected ResponseType responseType;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Request> requestList = new ArrayList<Request>();

        public Request(Node node) {
            super(node);
        }

        public String description() {
            return this.description;
        }

        public ResponseType responseType() {
            return this.responseType;
        }

        public void description(String value) {
            this.description = value;
        }

        public void responseType(ResponseType value) {
            this.responseType = value;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Request> requestList() {
            return Collections.unmodifiableList(this.requestList);
        }

        public Request request(int index) {
            return this.requestList.get(index);
        }

        public List<Request> requestList(Predicate<Request> predicate) {
            return this.requestList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.parameterList.stream().forEach(c -> components.add(c.node()));
            this.requestList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            map.put("responseType", new ArrayList<ResponseType>(Collections.singletonList(this.responseType)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Request.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("SlackBot#Service$Request$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("SlackBot#Service$Request")) {
                this.requestList.add((Request)node.as(Request.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("SlackBot#Service$Request$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("SlackBot#Service$Request")) {
                this.requestList.remove(node.as(Request.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)WordLoader.load(values, ResponseType.class, (Layer)this).get(0));
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            } else if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public static class Parameter
        extends Layer
        implements Terminal {
            protected Type type;
            protected boolean multiple;

            public Parameter(Node node) {
                super(node);
            }

            public Type type() {
                return this.type;
            }

            public boolean multiple() {
                return this.multiple;
            }

            public void type(Type value) {
                this.type = value;
            }

            public void multiple(boolean value) {
                this.multiple = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Parameter.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("multiple")) {
                    this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("multiple")) {
                    this.multiple = (Boolean)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }

            public static enum Type {
                Boolean,
                String,
                Double,
                Integer;

            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter(Parameter.Type type) {
                Parameter newElement = (Parameter)Request.this.graph().concept(Parameter.class).createNode(this.name, Request.this.node()).as(Parameter.class);
                newElement.node().set((Layer)newElement, "type", Collections.singletonList(type));
                return newElement;
            }

            public Request request(String description) {
                Request newElement = (Request)Request.this.graph().concept(Request.class).createNode(this.name, Request.this.node()).as(Request.class);
                newElement.node().set((Layer)newElement, "description", Collections.singletonList(description));
                return newElement;
            }
        }

        public static enum ResponseType {
            Text,
            Attachment;

        }
    }

    public static class Notification
    extends Layer
    implements Terminal {
        protected String channel;

        public Notification(Node node) {
            super(node);
        }

        public String channel() {
            return this.channel;
        }

        public void channel(String value) {
            this.channel = value;
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("channel", new ArrayList<String>(Collections.singletonList(this.channel)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Notification.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("channel")) {
                this.channel = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("channel")) {
                this.channel = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Notification notification(String channel) {
            Notification newElement = (Notification)SlackBotService.this.graph().concept(Notification.class).createNode(this.name, SlackBotService.this.node()).as(Notification.class);
            newElement.node().set((Layer)newElement, "channel", Collections.singletonList(channel));
            return newElement;
        }

        public Request request(String description) {
            Request newElement = (Request)SlackBotService.this.graph().concept(Request.class).createNode(this.name, SlackBotService.this.node()).as(Request.class);
            newElement.node().set((Layer)newElement, "description", Collections.singletonList(description));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)SlackBotService.this.graph().concept(Schema.class).createNode(this.name, SlackBotService.this.node()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)SlackBotService.this.graph().concept(Exception.class).createNode(this.name, SlackBotService.this.node()).as(Exception.class);
            newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

