/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.jms.service;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.JMSRequestActionRenderer;
import io.intino.konos.builder.codegeneration.server.jms.service.JMSRequestTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Response;
import io.intino.konos.model.Schema;
import io.intino.konos.model.jms.JMSService;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class JMSRequestRenderer {
    private static final String REQUESTS = "requests";
    private final Project project;
    private final List<JMSService> services;
    private File gen;
    private File src;
    private String packageName;
    private final String boxName;

    public JMSRequestRenderer(Project project, Graph graph, File src, File gen, String packageName, String boxName) {
        this.project = project;
        this.services = graph.find(JMSService.class);
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(JMSService service) {
        service.node().findNode(JMSService.Request.class).forEach(this::processRequest);
    }

    private void processRequest(JMSService.Request resource) {
        Frame frame = this.fillRequestFrame(resource);
        Commons.writeFrame(new File(this.gen, REQUESTS), StringHelper.snakeCaseToCamelCase((String)resource.name()) + "Request", this.template().format((Object)frame));
        this.createCorrespondingAction(resource);
    }

    private void createCorrespondingAction(JMSService.Request request) {
        new JMSRequestActionRenderer(this.project, request, this.src, this.packageName, this.boxName).execute();
    }

    private Frame fillRequestFrame(JMSService.Request request) {
        String returnType = Commons.returnType(request.response());
        Frame frame = new Frame().addTypes(new String[]{"request"}).addSlot("name", new String[]{request.name()}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("call", new AbstractFrame[]{new Frame().addTypes(new String[]{returnType})}).addSlot("parameter", (AbstractFrame[])this.parameters(request.parameterList()));
        if (!returnType.equals("void")) {
            frame.addSlot("returnType", new String[]{returnType}).addSlot("returnMessageType", new String[]{this.messageType(request.response())});
        }
        if (!request.exceptionList().isEmpty() || !request.exceptionRefs().isEmpty()) {
            frame.addSlot("exception", new String[]{""});
        }
        if (!request.graph().find(Schema.class).isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame().addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        return frame;
    }

    private String messageType(Response response) {
        return response.isFile() ? "Bytes" : "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        Frame frame = new Frame();
        if (parameter.isList()) {
            frame.addTypes(new String[]{"List"});
        }
        return frame.addTypes(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).addSlot("name", new String[]{parameter.name()}).addSlot("type", new String[]{parameter.asType().type()});
    }

    private Template template() {
        return Formatters.customize(JMSRequestTemplate.create());
    }
}

