/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.slack;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.server.slack.BotActionsUpdater;
import io.intino.konos.builder.codegeneration.server.slack.SlackTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.slackbot.SlackBotService;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class SlackRenderer {
    private final Project project;
    private final List<SlackBotService> services;
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public SlackRenderer(Project project, Graph graph, File src, File gen, String packageName, String boxName) {
        this.project = project;
        this.services = graph.find(SlackBotService.class);
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(SlackBotService service) {
        String srcName = StringHelper.snakeCaseToCamelCase((String)service.name()) + "Slack";
        Frame frame = this.createFrame(service.name(), service.requestList(), true);
        for (String level : this.collectLevels(service).keySet()) {
            frame.addSlot("level", new AbstractFrame[]{new Frame().addTypes(new String[]{"level"}).addSlot("name", new String[]{level})});
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)service.name()) + "SlackBot", this.template().format((Object)frame));
        if (this.alreadyRendered(this.src, srcName)) {
            this.updateBot(service, srcName);
        } else {
            this.newBotActions(service);
        }
    }

    private void updateBot(SlackBotService service, String name) {
        new BotActionsUpdater(this.project, Commons.javaFile(this.src, name), service.requestList(), this.boxName).update();
        VirtualFileManager.getInstance().asyncRefresh(null);
    }

    private void newBotActions(SlackBotService service) {
        File directory = new File(this.src, "slack");
        if (!this.alreadyRendered(directory, StringHelper.snakeCaseToCamelCase((String)service.name()) + "Slack")) {
            Commons.writeFrame(directory, StringHelper.snakeCaseToCamelCase((String)service.name()) + "Slack", this.template().format((Object)this.createFrame(service.name(), service.requestList(), false)));
        }
        Map<String, List<SlackBotService.Request>> groups = this.collectLevels(service);
        for (String requestContainer : groups.keySet()) {
            if (this.alreadyRendered(directory, requestContainer + "Slack")) continue;
            Commons.writeFrame(directory, requestContainer + "Slack", this.template().format((Object)this.createFrame(requestContainer, groups.get(requestContainer), false)));
        }
    }

    private Map<String, List<SlackBotService.Request>> collectLevels(SlackBotService service) {
        Map collect = service.requestList().stream().filter(request -> !request.requestList().isEmpty()).collect(Collectors.toMap(Layer::name, SlackBotService.Request::requestList, (a, b) -> b, LinkedHashMap::new));
        return collect;
    }

    @NotNull
    private Frame createFrame(String name, List<SlackBotService.Request> requests, boolean gen) {
        Frame frame = new Frame().addTypes(new String[]{"slack", gen ? "gen" : "actions"});
        frame.addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name}).addSlot("box", new String[]{this.boxName});
        if (gen) {
            this.allRequests(requests, frame);
        } else {
            this.createRequests(requests, frame);
        }
        Frame frame2 = frame;
        if (frame2 == null) {
            SlackRenderer.$$$reportNull$$$0(0);
        }
        return frame2;
    }

    private void allRequests(List<SlackBotService.Request> requests, Frame frame) {
        for (SlackBotService.Request request : requests) {
            frame.addSlot("request", new AbstractFrame[]{this.createRequestFrame(request)});
            this.allRequests(request.requestList(), frame);
        }
    }

    private void createRequests(List<SlackBotService.Request> requests, Frame frame) {
        for (SlackBotService.Request request : requests) {
            frame.addSlot("request", new AbstractFrame[]{this.createRequestFrame(request)});
        }
    }

    private Frame createRequestFrame(SlackBotService.Request request) {
        Frame requestFrame = new Frame().addTypes(new String[]{"request"}).addSlot("type", new String[]{request.owner().name()}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{request.name()}).addSlot("description", new String[]{request.description()});
        if (request.owner().is(SlackBotService.Request.class)) {
            requestFrame.addSlot("context", new String[]{request.owner().name()});
        }
        requestFrame.addSlot("responseType", new String[]{request.responseType().equals((Object)SlackBotService.Request.ResponseType.Text) ? "String" : "SlackAttachment"});
        List<SlackBotService.Request.Parameter> parameters = request.parameterList();
        for (int i = 0; i < parameters.size(); ++i) {
            requestFrame.addSlot("parameter", new AbstractFrame[]{new Frame().addTypes(new String[]{"parameter", parameters.get(i).type().name(), parameters.get(i).multiple() ? "multiple" : "single"}).addSlot("type", new String[]{parameters.get(i).type().name()}).addSlot("name", new String[]{parameters.get(i).name()}).addSlot("pos", new Integer[]{i})});
        }
        for (SlackBotService.Request component : request.requestList()) {
            requestFrame.addSlot("component", new String[]{component.name()});
        }
        return requestFrame;
    }

    private Template template() {
        return Formatters.customize(SlackTemplate.create());
    }

    private boolean alreadyRendered(File destiny, String name) {
        return Commons.javaFile(destiny, name).exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/server/slack/SlackRenderer", "createFrame"));
    }
}

