/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.NessEventsTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.DataLake;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class NessEventsRenderer {
    private final List<DataLake> bus;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public NessEventsRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.bus = graph.find(DataLake.class);
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.bus.forEach(this::processDataLake);
    }

    private void processDataLake(DataLake bus) {
        Frame frame = new Frame().addTypes(new String[]{"bus"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{bus.name()}).addSlot("box", new String[]{this.boxName}).addSlot("eventHandler", (AbstractFrame[])bus.eventHandlerList().stream().map(this::frameOf).toArray(Frame[]::new));
        if (!bus.eventHandlerList().isEmpty()) {
            frame.addSlot("eventHandlerImport", new String[]{this.packageName});
        }
        Commons.writeFrame(this.gen, "NessEvents", this.template().format((Object)frame));
    }

    private Frame frameOf(DataLake.EventHandler handler) {
        Frame frame = new Frame().addTypes(new String[]{"eventHandler"}).addSlot("name", new String[]{handler.name()}).addSlot("messageType", new AbstractFrame[]{this.customize(handler.name(), handler.topic())}).addSlot("simpleMessageType", new String[]{handler.topic()});
        if (handler.isDurable()) {
            frame.addSlot("durable", new AbstractFrame[]{this.customizeDurable(handler.name(), handler.asDurable().topic())});
        }
        return frame;
    }

    private Frame customize(String name, String topic) {
        Frame frame = new Frame().addTypes(new String[]{"messageType"});
        frame.addSlot("name", new String[]{topic});
        for (String parameter : Commons.extractParameters(topic)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private Frame customizeDurable(String name, String clientId) {
        Frame frame = new Frame().addTypes(new String[]{"durable"}).addSlot("value", new String[]{""}).addSlot("conf", new String[]{name});
        for (String parameter : Commons.extractParameters(clientId)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private Frame custom(String name, String parameter) {
        return new Frame().addSlot("value", new String[]{parameter}).addSlot("conf", new String[]{name});
    }

    private Template template() {
        return Formatters.customize(NessEventsTemplate.create()).add("shortPath", value -> {
            String[] names = value.toString().split("\\.");
            return names[names.length - 1];
        });
    }
}

