/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.slack;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.server.slack.BotActionsUpdater;
import io.intino.konos.builder.codegeneration.server.slack.SlackTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.slackbot.SlackBotService;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class SlackRenderer {
    private final Project project;
    private final List<SlackBotService> services;
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public SlackRenderer(Project project, Graph graph, File src, File gen, String packageName, String boxName) {
        this.project = project;
        this.services = graph.find(SlackBotService.class);
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(SlackBotService service) {
        String srcName = StringHelper.snakeCaseToCamelCase((String)service.name()) + "SlackBotActions";
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)service.name()) + "SlackBot", this.template().format((Object)this.createFrame(service, true)));
        if (this.alreadyRendered(this.src, srcName)) {
            this.updateBot(service, srcName);
        } else {
            this.newBotActions(service, srcName);
        }
    }

    private void updateBot(SlackBotService service, String name) {
        new BotActionsUpdater(this.project, Commons.javaFile(this.src, name), service.requestList(), this.boxName).update();
        VirtualFileManager.getInstance().asyncRefresh(null);
    }

    private void newBotActions(SlackBotService service, String name) {
        Commons.writeFrame(this.src, name, this.template().format((Object)this.createFrame(service, false)));
    }

    @NotNull
    private Frame createFrame(SlackBotService service, boolean gen) {
        List<SlackBotService.Request> requests = service.requestList();
        Frame frame = new Frame().addTypes(new String[]{"slack", gen ? "gen" : "actions"});
        frame.addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{service.name()}).addSlot("box", new String[]{this.boxName});
        this.createRequests(service, requests, frame);
        Frame frame2 = frame;
        if (frame2 == null) {
            SlackRenderer.$$$reportNull$$$0(0);
        }
        return frame2;
    }

    private void createRequests(SlackBotService service, List<SlackBotService.Request> requests, Frame frame) {
        for (SlackBotService.Request request : requests) {
            frame.addSlot("request", new AbstractFrame[]{this.createRequestFrame(service, request)});
            this.createRequests(service, request.requestList(), frame);
        }
    }

    private Frame createRequestFrame(SlackBotService service, SlackBotService.Request request) {
        Frame requestFrame = new Frame().addTypes(new String[]{"request"}).addSlot("bot", new String[]{service.name()}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{request.name()}).addSlot("description", new String[]{request.description()});
        requestFrame.addSlot("responseType", new String[]{request.responseType().equals((Object)SlackBotService.Request.ResponseType.Text) ? "String" : "SlackAttachment"});
        List<SlackBotService.Request.Parameter> parameters = request.parameterList();
        for (int i = 0; i < parameters.size(); ++i) {
            requestFrame.addSlot("parameter", new AbstractFrame[]{new Frame().addTypes(new String[]{"parameter", parameters.get(i).type().name(), parameters.get(i).multiple() ? "multiple" : "single"}).addSlot("type", new String[]{parameters.get(i).type().name()}).addSlot("name", new String[]{parameters.get(i).name()}).addSlot("pos", new Integer[]{i})});
        }
        for (SlackBotService.Request component : request.requestList()) {
            requestFrame.addSlot("component", new String[]{component.name()});
        }
        return requestFrame;
    }

    private Template template() {
        return Formatters.customize(SlackTemplate.create());
    }

    private boolean alreadyRendered(File destiny, String name) {
        return Commons.javaFile(destiny, name).exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/server/slack/SlackRenderer", "createFrame"));
    }
}

