/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.eventhandling;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class BusTemplate
extends Template {
    protected BusTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new BusTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "bus")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(";\n\nimport io.intino.konos.jms.TopicConsumer;\nimport io.intino.konos.jms.TopicProducer;\nimport io.intino.konos.jms.Consumer;\nimport io.intino.konos.jms.Bus;\nimport org.apache.activemq.ActiveMQConnection;\nimport org.apache.activemq.advisory.DestinationListener;\nimport org.apache.activemq.advisory.DestinationSource;\nimport org.apache.activemq.command.ActiveMQTopic;\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box;\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Configuration;\n")).add((Token.Body)this.expression().add((Token.Body)this.mark("eventHandlerImport", new String[0]))).add((Token.Body)this.literal("\nimport javax.jms.JMSException;\nimport javax.jms.Message;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.logging.Level;\nimport java.util.logging.Logger;\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUppercase"})).add((Token.Body)this.literal("Bus extends Bus {\n\tprivate static Logger logger = Logger.getGlobal();\n\n\tprivate ")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Configuration configuration;\n\tprivate ")).add((Token.Body)this.mark("box", new String[]{"firstUppercase"})).add((Token.Body)this.literal("Box box;\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"firstUppercase"})).add((Token.Body)this.literal("Bus(")).add((Token.Body)this.mark("box", new String[]{"firstUppercase"})).add((Token.Body)this.literal("Box box) {\n\t\tthis.box = box;\n\t\tthis.configuration = box.configuration();\n\t\t")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Configuration.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Configuration busConfiguration = this.configuration.")).add((Token.Body)this.mark("name", new String[]{"firstLowerCase"})).add((Token.Body)this.literal("Configuration();\n\t\ttry {\n\t\t\tconnection = new org.apache.activemq.ActiveMQConnectionFactory(busConfiguration.user, busConfiguration.password, busConfiguration.url).createConnection();\n\t\t\tif (busConfiguration.clientID != null && !busConfiguration.clientID.isEmpty()) connection.setClientID(busConfiguration.clientID);\n\t\t\tconnection.start();\n\t\t\tthis.session = connection.createSession(false, javax.jms.Session.AUTO_ACKNOWLEDGE);\n\t\t\t")).add((Token.Body)this.mark("eventHandler", new String[]{"subscribe"}).multiple("\n")).add((Token.Body)this.literal("\n\t\t} catch (JMSException e) {\n\t\t\tlogger.log(Level.SEVERE, e.getMessage(), e);\n\t\t}\n\t}\n\t\n\tpublic List<String> topics() {\n\t\tList<String> topics = new ArrayList<>();\n\t\ttry {\n\t\t\tfor (ActiveMQTopic topic : ((ActiveMQConnection) connection).getDestinationSource().getTopics())\n\t\t\t\ttopics.add(topic.getTopicName());\n\t\t} catch (JMSException e) {\n\t\t}\n\t\treturn topics;\n\t}\n\t\n\tpublic void setListener(DestinationListener listener) {\n\t\ttry {\n\t\t\t((ActiveMQConnection) connection).getDestinationSource().setDestinationListener(listener);\n\t\t} catch (JMSException e) {\n\t\t}\n\t}\n\n\tprivate static class Subscriptor implements Consumer {\n\n\t\tprivate ")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box;\n\n\t\tSubscriptor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box) {\n\t\t\tthis.box = box;\n\t\t}\n\n\t\tpublic void consume(Message message) {\n\t\t\tString text = textFrom(message);\n\t\t\tString type = typeOf(text);\n\t\t\t")).add((Token.Body)this.mark("eventHandler", new String[]{"select"}).multiple("\n")).add((Token.Body)this.literal("\n\t\t}\n\t}\n}")), this.rule().add(new Condition[]{this.condition("type", "eventHandler"), this.condition("trigger", "field")}).add((Token.Body)this.literal("public static final String ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(" = ")).add((Token.Body)this.mark("messageType", new String[]{"format"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.condition("type", "eventHandler"), this.condition("trigger", "subscribe")}).add((Token.Body)this.literal("new TopicConsumer(session, ")).add((Token.Body)this.mark("messageType", new String[]{"format"})).add((Token.Body)this.literal(").listen(new Subscriptor(box)")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("durable", new String[0]))).add((Token.Body)this.literal(");")), this.rule().add(new Condition[]{this.condition("type", "durable"), this.condition("trigger", "durable")}).add((Token.Body)this.literal("this.configuration.")).add((Token.Body)this.mark("conf", new String[0])).add((Token.Body)this.literal("Configuration().clientID")).add((Token.Body)this.expression().add((Token.Body)this.mark("custom", new String[]{"replace"}).multiple(""))), this.rule().add(new Condition[]{this.condition("type", "custom"), this.condition("trigger", "replace")}).add((Token.Body)this.literal(".replace(\"{")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("}\", ")).add((Token.Body)this.mark("value", new String[]{"validname", "firstLowerCase"})).add((Token.Body)this.literal(")")), this.rule().add(new Condition[]{this.condition("trigger", "formatMessage")}).add((Token.Body)this.literal("\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\"")).add((Token.Body)this.expression().add((Token.Body)this.mark("custom", new String[]{"customType"}).multiple(""))), this.rule().add(new Condition[]{this.condition("trigger", "customType")}).add((Token.Body)this.literal(".replace(\"{")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("}\", box.configuration.")).add((Token.Body)this.mark("conf", new String[0])).add((Token.Body)this.literal("Configuration().")).add((Token.Body)this.mark("value", new String[]{"validname", "firstLowerCase"})).add((Token.Body)this.literal(")")), this.rule().add(new Condition[]{this.condition("trigger", "format")}).add((Token.Body)this.literal("\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\"")).add((Token.Body)this.expression().add((Token.Body)this.mark("custom", new String[0]).multiple(""))), this.rule().add(new Condition[]{this.condition("trigger", "custom")}).add((Token.Body)this.literal(".replace(\"{")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("}\", this.configuration.")).add((Token.Body)this.mark("conf", new String[0])).add((Token.Body)this.literal("Configuration().")).add((Token.Body)this.mark("value", new String[]{"validname", "firstLowerCase"})).add((Token.Body)this.literal(")")), this.rule().add(new Condition[]{this.condition("trigger", "eventHandler"), this.condition("trigger", "select")}).add((Token.Body)this.literal("if (")).add((Token.Body)this.mark("messageType", new String[]{"formatMessage"})).add((Token.Body)this.literal(".equalsIgnoreCase(type) || \"")).add((Token.Body)this.mark("simpleMessageType", new String[]{"shortPath"})).add((Token.Body)this.literal("\".equalsIgnoreCase(type)) {\n\t")).add((Token.Body)this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("EventHandler eventHandler = new ")).add((Token.Body)this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("EventHandler();\n\teventHandler.box = box;\n\teventHandler.message = text;\n\teventHandler.execute();\n}")), this.rule().add(new Condition[]{this.condition("trigger", "replace")}).add((Token.Body)this.literal(".replace(\"{")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("}\", configuration().")).add((Token.Body)this.mark("conf", new String[]{"firstLowerCase"})).add((Token.Body)this.literal("Configuration.")).add((Token.Body)this.mark("value", new String[]{"validname", "firstLowerCase"})).add((Token.Body)this.literal(")")), this.rule().add(new Condition[]{this.condition("trigger", "eventHandlerImport")}).add((Token.Body)this.literal("import ")).add((Token.Body)this.mark("value", new String[]{"validPackage"})).add((Token.Body)this.literal(".eventhandlers.*;"))});
        return this;
    }
}

