/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import io.intino.konos.builder.KonosIcons;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.util.ArrayList;
import java.util.List;

public class KonosActionGroup
extends DefaultActionGroup {
    public KonosActionGroup() {
        super("Konos", true);
        this.getTemplatePresentation().setText("Konos");
        this.getTemplatePresentation().setVisible(true);
        this.getTemplatePresentation().setEnabled(true);
        this.getTemplatePresentation().setIcon(KonosIcons.ICON_16);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = !this.collectModulesWithConfiguration(project).isEmpty();
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setIcon(KonosIcons.ICON_16);
    }

    private List<Module> collectModulesWithConfiguration(Project project) {
        ArrayList<Module> taraModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (TaraUtil.configurationOf((Module)module) == null) continue;
            taraModules.add(module);
        }
        return taraModules;
    }
}

