/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.activity.display;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.server.activity.display.DisplayRenderer;
import io.intino.konos.builder.codegeneration.server.activity.display.DisplayTemplate;
import io.intino.konos.model.Activity;
import java.io.File;

public class DisplayUpdater {
    private final PsiElementFactory factory;
    private final PsiFile file;
    private Project project;
    private Activity.Display display;

    public DisplayUpdater(Project project, Activity.Display display, File file) {
        this.project = project;
        this.factory = JavaPsiFacade.getElementFactory((Project)project);
        this.display = display;
        this.file = PsiManager.getInstance((Project)project).findFile(VfsUtil.findFileByIoFile((File)file, (boolean)true));
    }

    public void update() {
        if (this.file == null || !(this.file instanceof PsiJavaFile) || ((PsiJavaFile)this.file).getClasses()[0] == null) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)this.file;
        PsiClass psiClass = javaFile.getClasses()[0];
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> this.update(psiClass));
        } else {
            this.update(psiClass);
        }
    }

    private void update(PsiClass psiClass) {
        for (Activity.Display.Request request : this.display.requestList()) {
            if (this.methodOf(request, psiClass) != null) continue;
            this.addMethod(psiClass, request);
        }
    }

    private void addMethod(PsiClass psiClass, Activity.Display.Request request) {
        String methodText = Formatters.customize(DisplayTemplate.create()).format((Object)DisplayRenderer.frameOf(request));
        psiClass.addAfter((PsiElement)this.factory.createMethodFromText(methodText, (PsiElement)psiClass), (PsiElement)psiClass.getMethods()[psiClass.getMethods().length - 1]);
    }

    private PsiMethod methodOf(Activity.Display.Request request, PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getName().equals(this.nameOf(request))) continue;
            return psiMethod;
        }
        return null;
    }

    private String nameOf(Activity.Display.Request request) {
        return Formatters.firstLowerCase(Formatters.snakeCaseToCamelCase().format((Object)request.name()).toString());
    }
}

