/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.eventhandling;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.eventhandling.BusTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Bus;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class BusRenderer {
    private final List<Bus> bus;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public BusRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.bus = graph.find(Bus.class);
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.bus.forEach(this::processBus);
    }

    private void processBus(Bus bus) {
        Frame frame = new Frame().addTypes(new String[]{"bus"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{bus.name()}).addSlot("box", new String[]{this.boxName}).addSlot("eventHandler", (AbstractFrame[])bus.eventHandlerList().stream().map(this::frameOf).toArray(Frame[]::new));
        if (!bus.eventHandlerList().isEmpty()) {
            frame.addSlot("eventHandlerImport", new String[]{this.packageName});
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)bus.name()) + "Bus", this.template().format((Object)frame));
    }

    private Frame frameOf(Bus.EventHandler handler) {
        Frame frame = new Frame().addTypes(new String[]{"eventHandler"}).addSlot("name", new String[]{handler.name()}).addSlot("messageType", new AbstractFrame[]{this.customize(handler.name(), handler.topic())});
        if (handler.isDurable()) {
            frame.addSlot("durable", new AbstractFrame[]{this.customizeDurable(handler.name(), handler.asDurable().topic())});
        }
        return frame;
    }

    private Frame customize(String name, String path) {
        Frame frame = new Frame().addTypes(new String[]{"messageType"});
        frame.addSlot("name", new String[]{path});
        for (String parameter : Commons.extractParameters(path)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private Frame customizeDurable(String name, String clientId) {
        Frame frame = new Frame().addTypes(new String[]{"durable"}).addSlot("value", new String[]{""}).addSlot("conf", new String[]{name});
        for (String parameter : Commons.extractParameters(clientId)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private Frame custom(String name, String parameter) {
        return new Frame().addSlot("value", new String[]{parameter}).addSlot("conf", new String[]{name});
    }

    private Template template() {
        return Formatters.customize(BusTemplate.create());
    }
}

