/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Exception;
import io.intino.konos.model.Konos;
import io.intino.konos.model.Schema;
import io.intino.konos.model.jms.JMSService;
import io.intino.konos.model.jmx.JMXService;
import io.intino.konos.model.rest.RESTService;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.konos.model.slackbot.SlackBotService;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Service
extends Layer
implements Terminal {
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected List<Exception> exceptionList = new ArrayList<Exception>();

    public Service(Node node) {
        super(node);
    }

    public List<Schema> schemaList() {
        return Collections.unmodifiableList(this.schemaList);
    }

    public Schema schema(int index) {
        return this.schemaList.get(index);
    }

    public List<Schema> schemaList(Predicate<Schema> predicate) {
        return this.schemaList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Exception> exceptionList() {
        return Collections.unmodifiableList(this.exceptionList);
    }

    public Exception exception(int index) {
        return this.exceptionList.get(index);
    }

    public List<Exception> exceptionList(Predicate<Exception> predicate) {
        return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public JMSService asJMS() {
        return (JMSService)this.as(JMSService.class);
    }

    public JMSService asJMS(JMSService.SubscriptionModel subscriptionModel) {
        JMSService newElement = (JMSService)this.addFacet(JMSService.class);
        newElement.node().set((Layer)newElement, "subscriptionModel", Collections.singletonList(subscriptionModel));
        return newElement;
    }

    public boolean isJMS() {
        return this.is(JMSService.class);
    }

    public void removeJMS() {
        this.removeFacet(JMSService.class);
    }

    public RESTService asREST() {
        return (RESTService)this.as(RESTService.class);
    }

    public RESTService asREST(String basePath) {
        RESTService newElement = (RESTService)this.addFacet(RESTService.class);
        newElement.node().set((Layer)newElement, "basePath", Collections.singletonList(basePath));
        return newElement;
    }

    public boolean isREST() {
        return this.is(RESTService.class);
    }

    public void removeREST() {
        this.removeFacet(RESTService.class);
    }

    public JMXService asJMX() {
        Layer as = this.as(JMXService.class);
        return as != null ? (JMXService)as : (JMXService)this.addFacet(JMXService.class);
    }

    public boolean isJMX() {
        return this.is(JMXService.class);
    }

    public SlackBotService asSlackBot() {
        Layer as = this.as(SlackBotService.class);
        return as != null ? (SlackBotService)as : (SlackBotService)this.addFacet(SlackBotService.class);
    }

    public boolean isSlackBot() {
        return this.is(SlackBotService.class);
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.schemaList.stream().forEach(c -> components.add(c.node()));
        this.exceptionList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Service.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("Schema")) {
            this.schemaList.add((Schema)node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.add((Exception)node.as(Exception.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("Schema")) {
            this.schemaList.remove(node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.remove(node.as(Exception.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Schema schema() {
            Schema newElement = (Schema)Service.this.graph().concept(Schema.class).createNode(this.name, Service.this.node()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)Service.this.graph().concept(Exception.class).createNode(this.name, Service.this.node()).as(Exception.class);
            newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

