/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.jmx;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.jmx.JMXAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.codegeneration.server.jmx.JMXServerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Schema;
import io.intino.konos.model.jmx.JMXService;
import io.intino.konos.model.object.ObjectData;
import io.intino.konos.model.type.TypeData;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class JMXAccessorRenderer {
    private final JMXService service;
    private File destination;
    private String packageName;

    public JMXAccessorRenderer(JMXService restService, File destination, String packageName) {
        this.service = restService;
        this.destination = new File(destination, "konos");
        this.packageName = packageName + ".konos";
    }

    public void execute() {
        new SchemaRenderer(this.service.graph(), this.destination, this.packageName).execute();
        this.createInterface(this.service);
        this.createService(this.service);
    }

    private void createInterface(JMXService service) {
        Frame frame = new Frame().addTypes(new String[]{"jmx", "interface"});
        this.fillFrame(service, frame);
        Commons.writeFrame(this.destinationPackage(), service.name() + "MBean", this.interfaceTemplate().format((Object)frame));
    }

    private File destinationPackage() {
        return new File(this.destination, "jmx");
    }

    private void createService(JMXService service) {
        Frame frame = new Frame().addTypes(new String[]{"accessor"});
        this.fillFrame(service, frame);
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)service.name()) + "JMXAccessor", this.template().format((Object)frame));
    }

    private void fillFrame(JMXService service, Frame frame) {
        frame.addSlot("name", new String[]{service.name()});
        frame.addSlot("package", new String[]{this.packageName});
        if (!service.graph().find(Schema.class).isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame().addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        for (JMXService.Operation operation : service.operationList()) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(operation)});
        }
    }

    private Frame frameOf(JMXService.Operation operation) {
        Frame frame = new Frame().addTypes(new String[]{"operation"}).addSlot("name", new String[]{operation.name()}).addSlot("action", new String[]{operation.name()}).addSlot("package", new String[]{this.packageName}).addSlot("returnType", new String[]{operation.response() == null ? "void" : this.formatType(operation.response().asType())});
        this.setupParameters(operation.parameterList(), frame);
        return frame;
    }

    private String formatType(TypeData typeData) {
        return (typeData.is(ObjectData.class) ? this.packageName + ".schemas." : "") + typeData.type();
    }

    private void setupParameters(List<Parameter> parameters, Frame frame) {
        for (Parameter parameter : parameters) {
            frame.addSlot("parameter", new AbstractFrame[]{new Frame().addTypes(new String[]{"parameter"}).addSlot("name", new String[]{parameter.name()}).addSlot("type", new String[]{this.formatType(parameter.asType())})});
        }
    }

    private Template template() {
        return Formatters.customize(JMXAccessorTemplate.create());
    }

    private Template interfaceTemplate() {
        return Formatters.customize(JMXServerTemplate.create());
    }
}

