/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.eventhandling;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.eventhandling.EventHandlerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Bus;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.model.Frame;

public class EventHandlerRenderer {
    private final List<Bus.EventHandler> eventHandlers;
    private final File src;
    private final String packageName;
    private final String boxName;

    public EventHandlerRenderer(Graph graph, File src, String packageName, String boxName) {
        this.eventHandlers = graph.find(Bus.EventHandler.class);
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        for (Bus.EventHandler eventHandler : this.eventHandlers) {
            Frame frame = new Frame().addTypes(new String[]{"eventHandler"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{eventHandler.name()});
            File destination = new File(this.src, "eventhandlers");
            String name = Formatters.firstUpperCase(eventHandler.name()) + "EventHandler";
            if (this.alreadyRendered(destination, name)) continue;
            Commons.writeFrame(destination, name, Formatters.customize(EventHandlerTemplate.create()).format((Object)frame));
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

