/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import io.intino.konos.builder.KonosIcons;
import io.intino.konos.builder.file.KonosFileType;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.actions.utils.TaraTemplates;
import io.intino.tara.plugin.actions.utils.TaraTemplatesFactory;
import io.intino.tara.plugin.lang.psi.impl.TaraModelImpl;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import io.intino.tara.plugin.messages.MessageProvider;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateKonosFileAction
extends JavaCreateTemplateInPackageAction<TaraModelImpl> {
    public CreateKonosFileAction() {
        super("Konos File", "Creates a new Konos File", KonosIcons.ICON_16, true);
    }

    protected void buildDialog(Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle("Enter name for new Konos File");
        builder.addKind("Konos", KonosIcons.ICON_16, "Konos");
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return "Konos File";
    }

    protected boolean isAvailable(DataContext dataContext) {
        PsiElement data = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return (data instanceof PsiFile || data instanceof PsiDirectory) && super.isAvailable(dataContext);
    }

    @Nullable
    protected PsiElement getNavigationElement(@NotNull TaraModelImpl createdElement) {
        if (createdElement == null) {
            CreateKonosFileAction.$$$reportNull$$$0(0);
        }
        return createdElement;
    }

    @Nullable
    protected TaraModelImpl doCreate(PsiDirectory directory, String newName, String dsl) throws IncorrectOperationException {
        String template = TaraTemplates.getTemplate((String)"FILE");
        String fileName = newName + "." + KonosFileType.instance().getDefaultExtension();
        PsiFile file = TaraTemplatesFactory.createFromTemplate((PsiDirectory)directory, (String)newName, (String)fileName, (String)template, (boolean)true, (String[])new String[]{"DSL", dsl});
        return file instanceof TaraModelImpl ? (TaraModelImpl)file : this.error(file);
    }

    private TaraModelImpl error(PsiFile file) {
        String description = file.getFileType().getDescription();
        throw new IncorrectOperationException(MessageProvider.message((String)"tara.file.extension.is.not.mapped.to.tara.file.type", (Object[])new Object[]{description}));
    }

    protected void postProcess(TaraModelImpl createdElement, String templateName, Map<String, String> customProperties) {
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
        this.setCaret((PsiFile)createdElement);
        createdElement.navigate(true);
    }

    private void setCaret(PsiFile file) {
        PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)file.getProject());
        Document doc = instance.getDocument(file);
        if (doc == null) {
            return;
        }
        instance.commitDocument(doc);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(KonosIcons.ICON_16);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        boolean enabled = module != null && this.legioFile(module).exists();
        File file = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        if (!file.exists()) {
            return;
        }
        String version = file.getParentFile().getName();
        Configuration configuration = TaraUtil.configurationOf((Module)module);
        if (configuration == null) {
            enabled = false;
        }
        String interfaceVersion = configuration == null ? null : configuration.interfaceVersion();
        e.getPresentation().setVisible(enabled && version.equals(interfaceVersion));
        e.getPresentation().setEnabled(enabled && version.equals(interfaceVersion));
    }

    @NotNull
    private File legioFile(Module module) {
        File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
        File file = new File(moduleRoot, "configuration.legio");
        if (file == null) {
            CreateKonosFileAction.$$$reportNull$$$0(1);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/intino/konos/builder/actions/CreateKonosFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/intino/konos/builder/actions/CreateKonosFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "legioFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

