/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import cottons.utils.Files;
import io.intino.konos.builder.codegeneration.BoxConfigurationRenderer;
import io.intino.konos.builder.codegeneration.BoxRenderer;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.ActivityAccessorCreator;
import io.intino.konos.builder.codegeneration.exception.ExceptionRenderer;
import io.intino.konos.builder.codegeneration.main.LauncherRenderer;
import io.intino.konos.builder.codegeneration.main.MainRenderer;
import io.intino.konos.builder.codegeneration.main.SetupRenderer;
import io.intino.konos.builder.codegeneration.process.CommandRenderer;
import io.intino.konos.builder.codegeneration.process.task.TaskRenderer;
import io.intino.konos.builder.codegeneration.process.task.TaskerRenderer;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.codegeneration.server.activity.SchemaAdaptersRenderer;
import io.intino.konos.builder.codegeneration.server.activity.display.DisplayRenderer;
import io.intino.konos.builder.codegeneration.server.activity.web.ActivityRenderer;
import io.intino.konos.builder.codegeneration.server.activity.web.ResourceRenderer;
import io.intino.konos.builder.codegeneration.server.jms.connector.BusRenderer;
import io.intino.konos.builder.codegeneration.server.jms.connector.ChannelRenderer;
import io.intino.konos.builder.codegeneration.server.jms.service.JMSRequestRenderer;
import io.intino.konos.builder.codegeneration.server.jms.service.JMSServiceRenderer;
import io.intino.konos.builder.codegeneration.server.jmx.JMXOperationsServiceRenderer;
import io.intino.konos.builder.codegeneration.server.jmx.JMXServerRenderer;
import io.intino.konos.builder.codegeneration.server.rest.RESTResourceRenderer;
import io.intino.konos.builder.codegeneration.server.rest.RESTServiceRenderer;
import io.intino.konos.builder.codegeneration.server.slack.SlackRenderer;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Graph;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.siani.itrules.model.Frame;

public class FullRenderer {
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    private final Graph graph;
    private final File gen;
    private final File src;
    private File test;
    private final String packageName;
    private final String boxName;
    private final String parent;
    private final boolean isTara;

    public FullRenderer(@Nullable Module module, Graph graph, File src, File gen, File test, String packageName) {
        this.project = module == null ? null : module.getProject();
        this.module = module;
        this.graph = graph;
        this.gen = gen;
        this.src = src;
        this.test = test;
        this.packageName = packageName;
        this.parent = this.parent();
        this.isTara = this.isTara();
        this.boxName = this.boxName();
    }

    public void execute() {
        Files.removeDir((File)this.gen);
        this.schemas();
        this.exceptions();
        this.rest();
        this.process();
        this.jmx();
        this.jms();
        this.bus();
        this.slack();
        this.ui();
        this.main(this.box());
    }

    private void schemas() {
        new SchemaRenderer(this.graph, this.gen, this.packageName).execute();
    }

    private void exceptions() {
        new ExceptionRenderer(this.graph, this.gen, this.packageName).execute();
    }

    private void rest() {
        new RESTResourceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new RESTServiceRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void jmx() {
        new JMXOperationsServiceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new JMXServerRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void jms() {
        new JMSRequestRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new JMSServiceRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void process() {
        new CommandRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new TaskRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new TaskerRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void bus() {
        new BusRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new ChannelRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
    }

    private void slack() {
        new SlackRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
    }

    private void ui() {
        new DisplayRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new ResourceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new ActivityRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new ActivityAccessorCreator(this.module, this.graph).execute();
        new SchemaAdaptersRenderer(this.graph, this.gen, this.packageName).execute();
    }

    private Frame box() {
        new BoxRenderer(this.graph, this.gen, this.packageName, this.module, this.parent, this.isTara).execute();
        return new BoxConfigurationRenderer(this.graph, this.gen, this.packageName, this.module, this.parent).execute();
    }

    private String boxName() {
        if (this.module != null) {
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            if (configuration == null) {
                return "";
            }
            String dsl = configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private boolean isTara() {
        return this.module != null && JavaPsiFacade.getInstance((Project)this.module.getProject()).findClass("io.intino.tara.magritte.Graph", GlobalSearchScope.moduleWithLibrariesScope((Module)this.module)) != null;
    }

    private String parent() {
        try {
            if (this.module == null) {
                return null;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.module.getProject());
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            for (Configuration.LanguageLibrary languageLibrary : configuration.languages()) {
                String workingPackage = languageLibrary.generationPackage();
                if (workingPackage == null || facade.findClass(workingPackage + ".konos." + Formatters.firstUpperCase(languageLibrary.name()) + "Box", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module)) == null) continue;
                return workingPackage.toLowerCase() + ".konos." + Formatters.firstUpperCase(languageLibrary.name());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void main(Frame frame) {
        new SetupRenderer(this.src, this.packageName, this.module).execute();
        new MainRenderer(this.gen, this.packageName, this.module).execute();
        new LauncherRenderer(this.test, frame).execute();
    }
}

