/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.rest;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.server.rest.RESTServiceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.rest.RESTService;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class RESTServiceRenderer {
    private final List<RESTService> services;
    private final File gen;
    private String packageName;
    private final String boxName;

    public RESTServiceRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.services = graph.find(RESTService.class);
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(service -> this.processService((RESTService)service.as(RESTService.class), this.gen));
    }

    private void processService(RESTService service, File gen) {
        if (service.resourceList().isEmpty()) {
            return;
        }
        Frame frame = new Frame().addTypes(new String[]{"server"}).addSlot("name", new String[]{service.name()}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("resource", (AbstractFrame[])this.processResources(service.resourceList()));
        RESTService.AuthenticatedWithCertificate secure = service.authenticatedWithCertificate();
        if (secure != null && secure.store() != null) {
            frame.addSlot("secure", new AbstractFrame[]{new Frame().addTypes(new String[]{"secure"}).addSlot("file", new String[]{secure.store().getPath()}).addSlot("password", new String[]{secure.storePassword()})});
        }
        Commons.writeFrame(gen, StringHelper.snakeCaseToCamelCase((String)service.name()) + "Resources", this.template().format((Object)frame));
    }

    private Frame[] processResources(List<RESTService.Resource> resources) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        for (RESTService.Resource resource : resources) {
            list.addAll(this.processResource(resource, resource.operationList()));
        }
        return list.toArray(new Frame[list.size()]);
    }

    private List<Frame> processResource(RESTService.Resource resource, List<RESTService.Resource.Operation> operations) {
        return operations.stream().map(operation -> new Frame().addTypes(new String[]{"resource", operation.concept().name()}).addSlot("name", new String[]{resource.name()}).addSlot("operation", new String[]{operation.concept().name()}).addSlot("path", new AbstractFrame[]{this.customize(Commons.path(resource))}).addSlot("method", new String[]{operation.concept().name()})).collect(Collectors.toList());
    }

    private Frame customize(String path) {
        Frame frame = new Frame().addTypes(new String[]{"path"});
        frame.addSlot("name", new String[]{path});
        for (String parameter : Commons.extractParameters(path)) {
            frame.addSlot("custom", new String[]{parameter});
        }
        return frame;
    }

    private Template template() {
        return Formatters.customize(RESTServiceTemplate.create());
    }
}

