/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.process.task;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.process.task.TaskerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Task;
import io.intino.konos.model.boottrigger.BootTriggerTask;
import io.intino.konos.model.crontrigger.CronTriggerTask;
import io.intino.konos.model.directorysentinel.DirectorySentinelTask;
import io.intino.konos.model.scheduled.ScheduledTask;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class TaskerRenderer {
    private final List<Task> tasks;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public TaskerRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.tasks = graph.find(Task.class);
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        if (this.tasks.isEmpty()) {
            return;
        }
        Frame frame = new Frame().addTypes(new String[]{"tasker"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("task", (AbstractFrame[])this.processTasks(this.tasks));
        Commons.writeFrame(this.gen, "Tasks", this.template().format((Object)frame));
    }

    private Frame[] processTasks(List<Task> tasks) {
        ArrayList list = new ArrayList();
        list.addAll(tasks.stream().filter(t -> t.is(ScheduledTask.class)).map(t -> (ScheduledTask)t.as(ScheduledTask.class)).map(this::processTask).collect(Collectors.toList()));
        list.addAll(tasks.stream().filter(t -> t.is(DirectorySentinelTask.class)).map(t -> (DirectorySentinelTask)t.as(DirectorySentinelTask.class)).map(this::processDirectorySentinel).collect(Collectors.toList()));
        return list.toArray(new Frame[list.size()]);
    }

    private Frame processTask(ScheduledTask task) {
        Frame schedule = new Frame().addTypes(new String[]{"task"}).addTypes(new String[]{((Object)((Object)task)).getClass().getSimpleName()}).addSlot("name", new String[]{task.name()});
        Frame jobFrame = new Frame().addTypes(new String[]{"job"}).addTypes(new String[]{((Object)((Object)task)).getClass().getSimpleName()}).addSlot("name", new String[]{task.id()});
        if (task.is(CronTriggerTask.class)) {
            CronTriggerTask cron = (CronTriggerTask)task.as(CronTriggerTask.class);
            jobFrame.addTypes(new String[]{"cronTrigger"}).addSlot("pattern", new String[]{cron.pattern()}).addSlot("mean", new String[]{cron.mean()});
        } else if (task.is(BootTriggerTask.class)) {
            jobFrame.addTypes(new String[]{"onBootTrigger"});
        }
        schedule.addSlot("job", new AbstractFrame[]{jobFrame});
        return schedule;
    }

    private Frame processDirectorySentinel(DirectorySentinelTask task) {
        Frame sentinel = new Frame().addTypes(new String[]{"task"}).addTypes(new String[]{((Object)((Object)task)).getClass().getSimpleName()});
        sentinel.addSlot("event", (String[])task.events().stream().map(Enum::name).toArray(String[]::new));
        sentinel.addSlot("file", new String[]{task.directory() == null ? "" : task.directory().getPath()});
        sentinel.addSlot("name", new String[]{task.name()});
        sentinel.addSlot("package", new String[]{this.packageName});
        return sentinel;
    }

    private Template template() {
        return Formatters.customize(TaskerTemplate.create());
    }
}

