/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.main;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.main.SetupTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.dsl.Proteo;
import io.intino.tara.dsl.Verso;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.ArrayList;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class SetupRenderer {
    private final File destination;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;

    public SetupRenderer(File destination, String packageName, Module module) {
        this.destination = destination;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
    }

    public void execute() {
        if (this.configuration == null || Commons.javaFile(this.destination, "Setup").exists()) {
            return;
        }
        String name = this.name();
        Frame frame = new Frame().addTypes(new String[]{"Setup"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name}).addSlot("wrapper", this.dsls());
        if (this.configuration.outDSL() != null) {
            frame.addSlot("outDSL", new String[]{this.configuration.outDSL()});
        }
        if (JavaPsiFacade.getInstance((Project)this.module.getProject()).findClass("io.intino.konos.server.activity.services.AuthService", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module)) != null) {
            frame.addSlot("rest", new String[]{name});
        }
        Commons.writeFrame(this.destination, "Setup", this.template().format((Object)frame));
    }

    private String[] dsls() {
        ArrayList<String> dsls = new ArrayList<String>();
        for (Configuration.LanguageLibrary lang : this.configuration.languages()) {
            if (lang.name().equals(Verso.class.getSimpleName()) || lang.name().equals(Proteo.class.getSimpleName())) continue;
            dsls.add(lang.generationPackage().toLowerCase() + "." + Formatters.firstUpperCase(lang.name()));
        }
        if (this.configuration.level() != Configuration.Level.System) {
            dsls.add(this.configuration.workingPackage().toLowerCase() + "." + Formatters.firstUpperCase(this.configuration.outDSL()));
        }
        return dsls.toArray(new String[dsls.size()]);
    }

    private Template template() {
        return Formatters.customize(SetupTemplate.create());
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            return dsl == null || dsl.isEmpty() ? this.module.getName() : dsl;
        }
        return "System";
    }
}

