/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Konos;
import io.intino.konos.model.durable.bus.DurableChannel;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Bus
extends Layer
implements Terminal {
    protected List<Channel> channelList = new ArrayList<Channel>();
    protected List<Queue> queueList = new ArrayList<Queue>();
    protected List<Topic> topicList = new ArrayList<Topic>();

    public Bus(Node node) {
        super(node);
    }

    public List<Channel> channelList() {
        return Collections.unmodifiableList(this.channelList);
    }

    public Channel channel(int index) {
        return this.channelList.get(index);
    }

    public List<Channel> channelList(Predicate<Channel> predicate) {
        return this.channelList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Queue> queueList() {
        return Collections.unmodifiableList(this.queueList);
    }

    public Queue queue(int index) {
        return this.queueList.get(index);
    }

    public List<Queue> queueList(Predicate<Queue> predicate) {
        return this.queueList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Topic> topicList() {
        return Collections.unmodifiableList(this.topicList);
    }

    public Topic topic(int index) {
        return this.topicList.get(index);
    }

    public List<Topic> topicList(Predicate<Topic> predicate) {
        return this.topicList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.channelList.stream().forEach(c -> components.add(c.node()));
        this.queueList.stream().forEach(c -> components.add(c.node()));
        this.topicList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Bus.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("Bus$Channel")) {
            this.channelList.add((Channel)node.as(Channel.class));
        }
        if (node.is("Bus$Queue")) {
            this.queueList.add((Queue)node.as(Queue.class));
        }
        if (node.is("Bus$Topic")) {
            this.topicList.add((Topic)node.as(Topic.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("Bus$Channel")) {
            this.channelList.remove(node.as(Channel.class));
        }
        if (node.is("Bus$Queue")) {
            this.queueList.remove(node.as(Queue.class));
        }
        if (node.is("Bus$Topic")) {
            this.topicList.remove(node.as(Topic.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Topic
    extends Channel
    implements Terminal {
        public Topic(Node node) {
            super(node);
        }

        @Override
        public DurableChannel asDurable() {
            return (DurableChannel)this.as(DurableChannel.class);
        }

        @Override
        public DurableChannel asDurable(String clientID) {
            DurableChannel newElement = (DurableChannel)this.addFacet(DurableChannel.class);
            newElement.node().set((Layer)newElement, "clientID", Collections.singletonList(clientID));
            return newElement;
        }

        @Override
        public boolean isDurable() {
            return this.is(DurableChannel.class);
        }

        @Override
        public void removeDurable() {
            this.removeFacet(DurableChannel.class);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(Topic.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Channel.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class Queue
    extends Channel
    implements Terminal {
        public Queue(Node node) {
            super(node);
        }

        @Override
        public DurableChannel asDurable() {
            return (DurableChannel)this.as(DurableChannel.class);
        }

        @Override
        public DurableChannel asDurable(String clientID) {
            DurableChannel newElement = (DurableChannel)this.addFacet(DurableChannel.class);
            newElement.node().set((Layer)newElement, "clientID", Collections.singletonList(clientID));
            return newElement;
        }

        @Override
        public boolean isDurable() {
            return this.is(DurableChannel.class);
        }

        @Override
        public void removeDurable() {
            this.removeFacet(DurableChannel.class);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(Queue.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Channel.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static abstract class Channel
    extends Layer
    implements Terminal {
        protected String path;

        public Channel(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public void path(String value) {
            this.path = value;
        }

        public DurableChannel asDurable() {
            return (DurableChannel)this.as(DurableChannel.class);
        }

        public DurableChannel asDurable(String clientID) {
            DurableChannel newElement = (DurableChannel)this.addFacet(DurableChannel.class);
            newElement.node().set((Layer)newElement, "clientID", Collections.singletonList(clientID));
            return newElement;
        }

        public boolean isDurable() {
            return this.is(DurableChannel.class);
        }

        public void removeDurable() {
            this.removeFacet(DurableChannel.class);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Channel.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Queue queue(String path) {
            Queue newElement = (Queue)Bus.this.graph().concept(Queue.class).createNode(this.name, Bus.this.node()).as(Queue.class);
            newElement.node().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public Topic topic(String path) {
            Topic newElement = (Topic)Bus.this.graph().concept(Topic.class).createNode(this.name, Bus.this.node()).as(Topic.class);
            newElement.node().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }
    }
}

