/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.activity;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.codegeneration.server.activity.SchemaAdapterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Activity;
import io.intino.konos.model.Schema;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.Collection;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class SchemaAdaptersRenderer {
    private final Collection<Schema> schemas;
    private final File destination;
    private final String packageName;
    private final Graph graph;

    public SchemaAdaptersRenderer(Graph graph, File destination, String packageName) {
        this.graph = graph;
        this.schemas = this.findActivitySchemas(this.graph);
        this.destination = destination;
        this.packageName = packageName;
    }

    public void execute() {
        if (this.graph.find(Activity.class).isEmpty()) {
            return;
        }
        Frame[] schemaFrames = (Frame[])this.schemas.stream().map(this::processSchema).toArray(Frame[]::new);
        Commons.writeFrame(new File(this.destination, "schemas"), "ActivitySchemaAdapters", this.template().format((Object)new Frame().addTypes(new String[]{"adapters"}).addSlot("package", new String[]{this.packageName}).addSlot("schema", (AbstractFrame[])schemaFrames)));
    }

    private Template template() {
        Template template = Formatters.customize(SchemaAdapterTemplate.create());
        template.add("typeFormat", value -> value.toString().contains(".") ? Formatters.firstLowerCase(value.toString()) : value);
        return template;
    }

    private Frame processSchema(Schema element) {
        return SchemaRenderer.createSchemaFrame(element, this.packageName, this.packageName);
    }

    private Collection<Schema> findActivitySchemas(Graph graph) {
        return graph.find(Schema.class);
    }
}

