/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.jms;

import io.intino.konos.model.Exception;
import io.intino.konos.model.Konos;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Response;
import io.intino.konos.model.Service;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JMSService
extends Layer
implements Terminal {
    protected SubscriptionModel subscriptionModel;
    protected List<Request> requestList = new ArrayList<Request>();
    protected List<Notification> notificationList = new ArrayList<Notification>();
    protected List<Authentication> authenticationList = new ArrayList<Authentication>();
    protected List<CredentialSecured> credentialSecuredList = new ArrayList<CredentialSecured>();
    protected List<CertificateSecured> certificateSecuredList = new ArrayList<CertificateSecured>();
    protected Service _service;

    public JMSService(Node node) {
        super(node);
    }

    public SubscriptionModel subscriptionModel() {
        return this.subscriptionModel;
    }

    public void subscriptionModel(SubscriptionModel value) {
        this.subscriptionModel = value;
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Authentication> authenticationList() {
        return Collections.unmodifiableList(this.authenticationList);
    }

    public Authentication authentication(int index) {
        return this.authenticationList.get(index);
    }

    public List<Authentication> authenticationList(Predicate<Authentication> predicate) {
        return this.authenticationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<CredentialSecured> credentialSecuredList() {
        return Collections.unmodifiableList(this.credentialSecuredList);
    }

    public CredentialSecured credentialSecured(int index) {
        return this.credentialSecuredList.get(index);
    }

    public List<CredentialSecured> credentialSecuredList(Predicate<CredentialSecured> predicate) {
        return this.credentialSecuredList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<CertificateSecured> certificateSecuredList() {
        return Collections.unmodifiableList(this.certificateSecuredList);
    }

    public CertificateSecured certificateSecured(int index) {
        return this.certificateSecuredList.get(index);
    }

    public List<CertificateSecured> certificateSecuredList(Predicate<CertificateSecured> predicate) {
        return this.certificateSecuredList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.requestList.stream().forEach(c -> components.add(c.node()));
        this.notificationList.stream().forEach(c -> components.add(c.node()));
        this.authenticationList.stream().forEach(c -> components.add(c.node()));
        this.credentialSecuredList.stream().forEach(c -> components.add(c.node()));
        this.certificateSecuredList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("subscriptionModel", new ArrayList<SubscriptionModel>(Collections.singletonList(this.subscriptionModel)));
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Service.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("JMS#Service$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
        if (node.is("JMS#Service$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
        if (node.is("JMS#Service$Authentication")) {
            this.authenticationList.add((Authentication)node.as(Authentication.class));
        }
        if (node.is("JMS#Service$CredentialSecured")) {
            this.credentialSecuredList.add((CredentialSecured)node.as(CredentialSecured.class));
        }
        if (node.is("JMS#Service$CertificateSecured")) {
            this.certificateSecuredList.add((CertificateSecured)node.as(CertificateSecured.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("JMS#Service$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
        if (node.is("JMS#Service$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
        if (node.is("JMS#Service$Authentication")) {
            this.authenticationList.remove(node.as(Authentication.class));
        }
        if (node.is("JMS#Service$CredentialSecured")) {
            this.credentialSecuredList.remove(node.as(CredentialSecured.class));
        }
        if (node.is("JMS#Service$CertificateSecured")) {
            this.certificateSecuredList.remove(node.as(CertificateSecured.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("subscriptionModel")) {
            this.subscriptionModel = (SubscriptionModel)((Object)WordLoader.load(values, SubscriptionModel.class, (Layer)this).get(0));
        }
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("subscriptionModel")) {
            this.subscriptionModel = (SubscriptionModel)((Object)values.get(0));
        }
    }

    protected void _sync(Layer layer) {
        super._sync(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class CertificateSecured
    extends Authentication
    implements Terminal {
        protected String certificate;

        public CertificateSecured(Node node) {
            super(node);
        }

        public String certificate() {
            return this.certificate;
        }

        public void certificate(String value) {
            this.certificate = value;
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            map.put("certificate", new ArrayList<String>(Collections.singletonList(this.certificate)));
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(CertificateSecured.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("certificate")) {
                this.certificate = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("certificate")) {
                this.certificate = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Authentication.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class CredentialSecured
    extends Authentication
    implements Terminal {
        protected String username;
        protected String password;

        public CredentialSecured(Node node) {
            super(node);
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public void username(String value) {
            this.username = value;
        }

        public void password(String value) {
            this.password = value;
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            map.put("username", new ArrayList<String>(Collections.singletonList(this.username)));
            map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(CredentialSecured.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("username")) {
                this.username = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("username")) {
                this.username = (String)values.get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Authentication.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static abstract class Authentication
    extends Layer
    implements Terminal {
        public Authentication(Node node) {
            super(node);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Authentication.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Notification
    extends Layer
    implements Terminal {
        protected String path;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();

        public Notification(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public void path(String value) {
            this.path = value;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.parameterList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Notification.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Notification.this.graph().concept(Parameter.class).createNode(this.name, Notification.this.node()).as(Parameter.class);
                return newElement;
            }
        }
    }

    public static class Request
    extends Layer
    implements Terminal {
        protected String path;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();
        protected Response response;

        public Request(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public void path(String value) {
            this.path = value;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Response response() {
            return this.response;
        }

        public void response(Response value) {
            this.response = value;
        }

        public List<Node> componentList() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
            this.parameterList.stream().forEach(c -> components.add(c.node()));
            this.exceptionList.stream().forEach(c -> components.add(c.node()));
            if (this.response != null) {
                components.add(this.response.node());
            }
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Request.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = (Response)node.as(Response.class);
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = null;
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().loadNode(((Layer)s).id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Request.this.graph().concept(Parameter.class).createNode(this.name, Request.this.node()).as(Parameter.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Request.this.graph().concept(Exception.class).createNode(this.name, Request.this.node()).as(Exception.class);
                newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }

            public Response response() {
                Response newElement = (Response)Request.this.graph().concept(Response.class).createNode(this.name, Request.this.node()).as(Response.class);
                return newElement;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Request request(String path) {
            Request newElement = (Request)JMSService.this.graph().concept(Request.class).createNode(this.name, JMSService.this.node()).as(Request.class);
            newElement.node().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public Notification notification(String path) {
            Notification newElement = (Notification)JMSService.this.graph().concept(Notification.class).createNode(this.name, JMSService.this.node()).as(Notification.class);
            newElement.node().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public CredentialSecured credentialSecured(String username, String password) {
            CredentialSecured newElement = (CredentialSecured)JMSService.this.graph().concept(CredentialSecured.class).createNode(this.name, JMSService.this.node()).as(CredentialSecured.class);
            newElement.node().set((Layer)newElement, "username", Collections.singletonList(username));
            newElement.node().set((Layer)newElement, "password", Collections.singletonList(password));
            return newElement;
        }

        public CertificateSecured certificateSecured(String certificate) {
            CertificateSecured newElement = (CertificateSecured)JMSService.this.graph().concept(CertificateSecured.class).createNode(this.name, JMSService.this.node()).as(CertificateSecured.class);
            newElement.node().set((Layer)newElement, "certificate", Collections.singletonList(certificate));
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)JMSService.this.graph().concept(Exception.class).createNode(this.name, JMSService.this.node()).as(Exception.class);
            newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }

    public static enum SubscriptionModel {
        Queue,
        Topic;

    }
}

