/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.jms.service;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class JMSServiceTemplate
extends Template {
    protected JMSServiceTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new JMSServiceTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "jms")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(";\n\nimport ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".requests.*;\nimport io.intino.konos.Box;\nimport io.intino.konos.jms.")).add((Token.Body)this.mark("model", new String[0])).add((Token.Body)this.literal("Consumer;\nimport io.intino.konos.jms.")).add((Token.Body)this.mark("model", new String[0])).add((Token.Body)this.literal("Producer;\n\nimport javax.jms.BytesMessage;\nimport javax.jms.JMSException;\nimport javax.jms.Session;\nimport javax.jms.TextMessage;\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("JMSService {\n\n\tprivate Session session;\n\tprivate ")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Configuration.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Configuration configuration;\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("JMSService(Session session, ")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box) {\n\t\tthis.session = session;\n\t\tthis.configuration = box.configuration().")).add((Token.Body)this.mark("name", new String[]{"firstLowerCase"})).add((Token.Body)this.literal("Configuration;\n\t\t")).add((Token.Body)this.mark("request", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\t")).add((Token.Body)this.mark("notification", new String[0]).multiple("\n\n")).add((Token.Body)this.literal("\n\n\tprivate byte[] toByteArray(InputStream stream) {\n\t\ttry {\n\t\t\tByteArrayOutputStream buffer = new ByteArrayOutputStream();\n\t\t\tint nRead;\n\t\t\tbyte[] data = new byte[16384];\n\t\t\twhile ((nRead = stream.read(data, 0, data.length)) != -1) {\n\t\t\t\tbuffer.write(data, 0, nRead);\n\t\t\t}\n\t\t\tbuffer.flush();\n\t\t\treturn buffer.toByteArray();\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\treturn new byte[0];\n\t}\n}")), this.rule().add(new Condition[]{this.condition("type", "request")}).add((Token.Body)this.literal("new ")).add((Token.Body)this.mark("model", new String[0])).add((Token.Body)this.literal("Consumer(session, ")).add((Token.Body)this.mark("queue", new String[]{"format"})).add((Token.Body)this.literal(").listen(new ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Request(box));")), this.rule().add(new Condition[]{this.condition("type", "notification")}).add((Token.Body)this.literal("public void notify")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("(")).add((Token.Body)this.expression().add((Token.Body)this.mark("parameter", new String[]{"signature"}).multiple(", "))).add((Token.Body)this.literal(") throws JMSException {\n\tfinal ")).add((Token.Body)this.mark("returnMessageType", new String[0])).add((Token.Body)this.literal("Message message = session.create")).add((Token.Body)this.mark("returnMessageType", new String[0])).add((Token.Body)this.literal("Message();\n\tfill")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Message(message")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("parameter", new String[]{"name"}).multiple(", "))).add((Token.Body)this.literal(");\n\tnew ")).add((Token.Body)this.mark("model", new String[0])).add((Token.Body)this.literal("Producer(session, ")).add((Token.Body)this.mark("queue", new String[]{"format"})).add((Token.Body)this.literal(").produce(message);\n}\n\nprivate void fill")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Message(")).add((Token.Body)this.mark("returnMessageType", new String[0])).add((Token.Body)this.literal("Message message")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("parameter", new String[]{"signature"}).multiple(", "))).add((Token.Body)this.literal(") throws JMSException {\n\t")).add((Token.Body)this.mark("parameter", new String[]{"assign"}).multiple("\n")).add((Token.Body)this.literal("\n}")), this.rule().add(new Condition[]{this.condition("type", "queue"), this.condition("trigger", "format")}).add((Token.Body)this.literal("\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\"")).add((Token.Body)this.expression().add((Token.Body)this.mark("custom", new String[0]).multiple(""))), this.rule().add(new Condition[]{this.condition("trigger", "custom")}).add((Token.Body)this.literal(".replace(\"{")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("}\", configuration.")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal(")")), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "name")}).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "signature")}).add((Token.Body)this.mark("type", new String[0])).add((Token.Body)this.literal(" ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})), this.rule().add(new Condition[]{this.condition("type", "parameter & fileData"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("message.writeBytes(toByteArray(")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("));")), this.rule().add(new Condition[]{this.condition("type", "parameter & objectData"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("message.setText(new Gson().toJson(")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("));")), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("message.set")).add((Token.Body)this.mark("type", new String[]{"formatted"})).add((Token.Body)this.literal("Property(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(");")), this.rule().add(new Condition[]{this.condition("attribute", "Integer"), this.condition("trigger", "formatted")}).add((Token.Body)this.literal("Int"))});
        return this;
    }
}

