/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.rest;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Exception;
import io.intino.konos.model.Response;
import io.intino.konos.model.Schema;
import io.intino.konos.model.date.DateData;
import io.intino.konos.model.datetime.DateTimeData;
import io.intino.konos.model.file.FileData;
import io.intino.konos.model.object.ObjectData;
import io.intino.konos.model.rest.RESTService;
import io.intino.konos.model.type.TypeData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class RESTAccessorRenderer {
    private final RESTService service;
    private File destination;
    private String packageName;

    public RESTAccessorRenderer(RESTService restService, File destination, String packageName) {
        this.service = restService;
        this.destination = destination;
        this.packageName = packageName;
    }

    public void execute() {
        new SchemaRenderer(this.service.graph(), this.destination, this.packageName).execute();
        this.processService(this.service);
    }

    private void processService(RESTService restService) {
        Frame frame = new Frame().addTypes(new String[]{"accessor"});
        frame.addSlot("name", new String[]{restService.name()});
        frame.addSlot("package", new String[]{this.packageName});
        this.setupAuthentication(restService, frame);
        if (!restService.graph().find(Schema.class).isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame().addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        ArrayList resourceFrames = new ArrayList();
        for (RESTService.Resource resource : restService.node().findNode(RESTService.Resource.class)) {
            resourceFrames.addAll(resource.operationList().stream().map(operation -> this.processOperation((RESTService.Resource.Operation)((Object)operation), restService.authenticated() != null, restService.authenticatedWithCertificate() != null)).collect(Collectors.toList()));
        }
        frame.addSlot("resource", resourceFrames.toArray(new AbstractFrame[resourceFrames.size()]));
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)restService.name()) + "Accessor", this.template().format((Object)frame));
    }

    private void setupAuthentication(RESTService restService, Frame frame) {
        if (restService.authenticated() != null) {
            frame.addSlot("auth", new String[]{""});
        }
        if (restService.authenticatedWithCertificate() != null) {
            frame.addSlot("certificate", new String[]{""});
        } else if (restService.authenticatedWithPassword() != null) {
            frame.addSlot("user", new String[]{""});
        }
    }

    private Frame processOperation(RESTService.Resource.Operation operation, boolean authenticated, boolean cert) {
        return new Frame().addTypes(new String[]{"resource"}).addSlot("returnType", new String[]{Commons.returnType(operation.response())}).addSlot("operation", new String[]{operation.concept().name()}).addSlot("name", new String[]{operation.owner().name()}).addSlot("parameter", (AbstractFrame[])this.parameters(operation.parameterList())).addSlot("invokeSentence", new AbstractFrame[]{this.invokeSentence(operation, authenticated, cert)}).addSlot("exceptionResponses", new AbstractFrame[]{this.exceptionResponses(operation)});
    }

    private Frame[] parameters(List<RESTService.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(RESTService.Resource.Parameter parameter) {
        return new Frame().addTypes(new String[]{"parameter", parameter.in().toString(), parameter.required() ? "required" : "optional", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).addSlot("name", new String[]{parameter.name()}).addSlot("parameterType", new String[]{parameter.asType().type()});
    }

    private Frame invokeSentence(RESTService.Resource.Operation operation, boolean authenticated, boolean cert) {
        Response response = operation.response();
        Frame result = response.asType() == null ? this.voidInvokeSentence() : (response.isObject() ? this.objectInvokeSentence(response.asObject()) : (response.isFile() ? this.fileInvokeSentence(response.asFile()) : (response.isDate() ? this.dateInvokeSentence(response.asDate()) : (response.isDateTime() ? this.dateTimeInvokeSentence(response.asDateTime()) : this.primitiveInvokeSentence(response.asType())))));
        if (response.isList()) {
            result.addTypes(new String[]{"list"});
        }
        return result.addSlot("doInvoke", new AbstractFrame[]{this.doInvoke(operation, authenticated, cert)});
    }

    private Frame doInvoke(RESTService.Resource.Operation operation, boolean authenticated, boolean cert) {
        Frame frame = new Frame().addTypes(new String[]{"doInvoke"}).addSlot("relativePath", new String[]{this.processPath(Commons.path((RESTService.Resource)operation.owner().as(RESTService.Resource.class)))}).addSlot("type", new String[]{operation.response().isFile() ? "getResource" : operation.concept().name().toLowerCase()});
        if (authenticated) {
            frame.addTypes(new String[]{"auth"});
        }
        if (cert) {
            frame.addTypes(new String[]{"cert"});
        }
        if (Commons.queryParameters(operation) > 0L || Commons.bodyParameters(operation) > 0L) {
            frame.addSlot("parameters", new String[]{"parameters"});
        } else if (Commons.fileParameters(operation) > 0) {
            frame.addSlot("parameters", new String[]{"resource"});
        }
        return frame;
    }

    private String processPath(String path) {
        StringBuilder builder = new StringBuilder();
        for (String pathPortion : path.split("/")) {
            if (pathPortion.startsWith(":")) {
                builder.append(" + \"/\" + ").append(this.asMethodParameter(pathPortion.substring(1)));
                continue;
            }
            builder.append(" + \"/").append(pathPortion).append("\"");
        }
        return builder.toString().substring(3);
    }

    private String asMethodParameter(String parameter) {
        String toCamelCase = StringHelper.snakeCaseToCamelCase((String)parameter);
        return Character.toLowerCase(toCamelCase.charAt(0)) + toCamelCase.substring(1);
    }

    private Frame exceptionResponses(RESTService.Resource.Operation operation) {
        List<Exception> exceptions = operation.exceptionList();
        if (exceptions.isEmpty()) {
            return new Frame().addTypes(new String[]{"exceptionResponses", "none"});
        }
        return new Frame().addTypes(new String[]{"exceptionResponses"}).addSlot("exceptionResponse", (AbstractFrame[])this.exceptionResponses(exceptions));
    }

    private Frame[] exceptionResponses(List<Exception> responses) {
        return (Frame[])responses.stream().map(this::exceptionResponse).toArray(Frame[]::new);
    }

    private Frame exceptionResponse(Exception response) {
        return new Frame().addTypes(new String[]{"exceptionResponse"}).addSlot("code", new String[]{response.code().value()}).addSlot("exceptionName", new String[]{response.code().toString()});
    }

    private Frame voidInvokeSentence() {
        return new Frame().addTypes(new String[]{"invokeSentence", "void"});
    }

    private Frame objectInvokeSentence(ObjectData objectData) {
        return new Frame().addTypes(new String[]{"invokeSentence", "object"}).addSlot("returnType", new String[]{objectData.type()});
    }

    private Frame fileInvokeSentence(FileData fileData) {
        return new Frame().addTypes(new String[]{"invokeSentence", "file"});
    }

    private Frame dateInvokeSentence(DateData dateData) {
        return new Frame().addTypes(new String[]{"invokeSentence", "file"});
    }

    private Frame dateTimeInvokeSentence(DateTimeData dateTimeData) {
        return new Frame().addTypes(new String[]{"invokeSentence", "file"});
    }

    private Frame primitiveInvokeSentence(TypeData typeData) {
        return new Frame().addTypes(new String[]{"invokeSentence", "primitive", typeData.type()}).addSlot("returnType", new String[]{typeData.type()});
    }

    private Template template() {
        return Formatters.customize(RESTAccessorTemplate.create());
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }
}

