/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.jms;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.accessor.jms.JMSAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Schema;
import io.intino.konos.model.jms.JMSService;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class JMSAccessorRenderer {
    private final JMSService service;
    private File destination;
    private String packageName;

    public JMSAccessorRenderer(JMSService application, File destination, String packageName) {
        this.service = application;
        this.destination = destination;
        this.packageName = packageName;
    }

    public void execute() {
        new SchemaRenderer(this.service.graph(), this.destination, this.packageName).execute();
        this.processService(this.service);
    }

    private void processService(JMSService jmsService) {
        Frame frame = new Frame().addTypes(new String[]{"accessor"});
        frame.addSlot("name", new String[]{jmsService.name()});
        frame.addSlot("package", new String[]{this.packageName});
        if (!jmsService.graph().find(Schema.class).isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame().addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        frame.addSlot("request", (AbstractFrame[])jmsService.node().findNode(JMSService.Request.class).stream().map(this::processRequest).toArray(Frame[]::new));
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)jmsService.name()) + "JMSAccessor", this.getTemplate().format((Object)frame));
    }

    private Frame processRequest(JMSService.Request request) {
        Frame frame = new Frame().addTypes(new String[]{"request"}).addSlot("name", new String[]{request.name()}).addSlot("queue", new String[]{request.path()}).addSlot("parameter", (AbstractFrame[])this.parameters(request.parameterList())).addSlot("messageType", new String[]{this.messageType(request.parameterList())});
        if (request.response() != null) {
            frame.addTypes(new String[]{"reply"});
            frame.addSlot("reply", new AbstractFrame[]{new Frame().addTypes(new String[]{"reply", ((Object)((Object)request.response().asType())).getClass().getSimpleName()}).addSlot("value", new String[]{request.response().asType().type()})});
        }
        return frame;
    }

    private String messageType(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isFile()) continue;
            return "Bytes";
        }
        return "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        return new Frame().addTypes(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).addSlot("name", new String[]{parameter.name()}).addSlot("type", new String[]{parameter.asType().type()});
    }

    private Template getTemplate() {
        Template template = JMSAccessorTemplate.create();
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
        return template;
    }
}

