/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.jms.connector;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.server.jms.connector.BusTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Bus;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class BusRenderer {
    private final List<Bus> bus;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public BusRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.bus = graph.find(Bus.class);
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.bus.forEach(this::processBus);
    }

    private void processBus(Bus bus) {
        Frame frame = new Frame().addTypes(new String[]{"bus"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{bus.name()}).addSlot("box", new String[]{this.boxName}).addSlot("channel", (String[])bus.channelList().stream().map(Layer::name).toArray(String[]::new));
        Commons.writeFrame(new File(this.gen, "bus"), StringHelper.snakeCaseToCamelCase((String)bus.name()) + "Bus", this.template().format((Object)frame));
    }

    private Template template() {
        return Formatters.customize(BusTemplate.create());
    }
}

