/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.BoxConfigurationTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Activity;
import io.intino.konos.model.Bus;
import io.intino.konos.model.Konos;
import io.intino.konos.model.Service;
import io.intino.konos.model.jms.JMSService;
import io.intino.konos.model.jmx.JMXService;
import io.intino.konos.model.rest.RESTService;
import io.intino.konos.model.slackbot.SlackBotService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class BoxConfigurationRenderer {
    private final Konos application;
    private final File gen;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;
    private String parent;

    public BoxConfigurationRenderer(Graph graph, File gen, String packageName, Module module, String parent) {
        this.application = (Konos)graph.wrapper(Konos.class);
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
    }

    public void execute() {
        Frame frame = new Frame().addTypes(new String[]{"boxconfiguration"});
        String boxName = this.name();
        frame.addSlot("name", new String[]{boxName});
        frame.addSlot("package", new String[]{this.packageName});
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            frame.addSlot("parent", new String[]{this.parent});
        }
        this.addRESTServices(frame, boxName);
        this.addJMSServices(frame, boxName);
        this.addJMXServices(frame, boxName);
        this.addSlackServices(frame, boxName);
        this.addBuses(frame, boxName);
        this.addChannels(frame, boxName);
        this.addActivities(frame, boxName);
        if (this.module != null && TaraUtil.configurationOf((Module)this.module) != null) {
            frame.addSlot("tara", new String[]{""});
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration", this.template().format((Object)frame));
    }

    private void addRESTServices(Frame frame, String boxName) {
        for (RESTService service : this.application.rESTServiceList()) {
            Frame restFrame = new Frame().addTypes(new String[]{"service", "rest"}).addSlot("name", new String[]{service.name()}).addSlot("configuration", new String[]{boxName});
            this.addUserVariables(service.as(Service.class), restFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{restFrame});
        }
    }

    private void addJMSServices(Frame frame, String boxName) {
        for (JMSService service : this.application.jMSServiceList()) {
            Frame jmsFrame = new Frame().addTypes(new String[]{"service", "jms"}).addSlot("name", new String[]{service.name()}).addSlot("configuration", new String[]{boxName});
            this.addUserVariables(service.as(Service.class), jmsFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{jmsFrame});
        }
    }

    private void addJMXServices(Frame frame, String boxName) {
        for (JMXService service : this.application.jMXServiceList()) {
            Frame jmsFrame = new Frame().addTypes(new String[]{"service", "jmx"}).addSlot("name", new String[]{service.name()}).addSlot("configuration", new String[]{boxName});
            frame.addSlot("service", new AbstractFrame[]{jmsFrame});
        }
    }

    private void addBuses(Frame frame, String boxName) {
        for (Bus bus : this.application.busList()) {
            Frame busFrame = new Frame().addTypes(new String[]{"service", "bus"}).addSlot("name", new String[]{bus.name()}).addSlot("configuration", new String[]{boxName});
            frame.addSlot("service", new AbstractFrame[]{busFrame});
        }
    }

    private void addChannels(Frame frame, String boxName) {
        for (Bus bus : this.application.busList()) {
            for (Bus.Channel channel : bus.channelList()) {
                Frame channelFrame = new Frame().addTypes(new String[]{"service", "channel"}).addSlot("name", new String[]{channel.name()}).addSlot("configuration", new String[]{boxName});
                this.addUserVariables(channel, channelFrame, this.findCustomParameters(channel));
                if (channel.isDurable()) {
                    channelFrame.addSlot("clientID", new String[]{channel.asDurable().clientID()});
                }
                frame.addSlot("service", new AbstractFrame[]{channelFrame});
            }
        }
    }

    private void addActivities(Frame frame, String boxName) {
        for (Activity activity : this.application.activityList()) {
            Frame activityFrame = new Frame().addTypes(new String[]{"service", "activity"}).addSlot("name", new String[]{activity.name()}).addSlot("configuration", new String[]{boxName});
            frame.addSlot("service", new AbstractFrame[]{activityFrame});
            if (activity.authenticated() != null) {
                activityFrame.addSlot("auth", new String[]{activity.authenticated().by()});
            }
            this.addUserVariables(activity, activityFrame, this.findCustomParameters(activity));
        }
    }

    private void addSlackServices(Frame frame, String boxName) {
        for (SlackBotService service : this.application.slackBotServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame().addTypes(new String[]{"service", "slack"}).addSlot("name", new String[]{service.name()}).addSlot("configuration", new String[]{boxName})});
        }
    }

    private void addUserVariables(Layer activity, Frame frame, Collection<String> userVariables) {
        for (String custom : userVariables) {
            frame.addSlot("custom", new AbstractFrame[]{new Frame().addTypes(new String[]{"custom"}).addSlot("conf", new String[]{activity.name()}).addSlot("name", new String[]{custom}).addSlot("type", new String[]{"String"})});
        }
    }

    private Set<String> findCustomParameters(Bus.Channel channel) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(Commons.extractParameters(channel.path()));
        if (channel.isDurable()) {
            set.addAll(Commons.extractParameters(channel.asDurable().clientID()));
        }
        return set;
    }

    private Set<String> findCustomParameters(JMSService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (JMSService.Request request : service.requestList()) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(Activity activity) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (activity.authenticated() != null) {
            set.addAll(Commons.extractParameters(activity.authenticated().by()));
        }
        for (Activity.AbstractPage page : activity.abstractPageList()) {
            for (String path : page.paths()) {
                set.addAll(Commons.extractParameters(path));
            }
        }
        return set;
    }

    private String name() {
        if (this.module != null) {
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            String dsl = configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(BoxConfigurationTemplate.create());
    }
}

