/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.rest.swagger;

import io.intino.konos.builder.codegeneration.accessor.rest.swagger.OpenApiDescriptor;
import io.intino.konos.model.Konos;
import io.intino.konos.model.rest.RESTService;
import io.swagger.codegen.SwaggerCodegen;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class SwaggerGenerator {
    private final Konos application;
    private final File outDirectory;

    public SwaggerGenerator(Konos application, File outDirectory) {
        this.application = application;
        this.outDirectory = outDirectory;
    }

    public void execute(List<String> targetLanguages) {
        for (RESTService restService : this.application.rESTServiceList()) {
            String jsonFilePath = this.writeFile(new OpenApiDescriptor(restService).createJSONDescriptor());
            SwaggerCodegen.main((String[])new String[]{"generate", "-i", jsonFilePath, "-o", this.outDirectory.getPath(), "-l", targetLanguages.get(0)});
        }
    }

    private String writeFile(String json) {
        try {
            return Files.write(Files.createTempFile("__swagger", ".json", new FileAttribute[0]), json.getBytes(), new OpenOption[0]).toFile().getPath();
        }
        catch (IOException ignored) {
            return "";
        }
    }
}

