/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.MainTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.ArrayList;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class MainRenderer {
    private final File destination;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;

    public MainRenderer(File destination, String packageName, Module module) {
        this.destination = destination;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
    }

    public void execute() {
        if (Commons.javaFile(this.destination, "Main").exists()) {
            return;
        }
        Frame frame = new Frame().addTypes(new String[]{"main"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{this.name()});
        if (this.configuration != null && Configuration.Level.System.equals((Object)this.configuration.level())) {
            frame.addSlot("wrapper", this.dsls());
            Commons.writeFrame(this.destination, "Main", this.template().format((Object)frame));
        }
    }

    private String[] dsls() {
        ArrayList<String> dsls = new ArrayList<String>();
        for (Configuration.LanguageLibrary lang : this.configuration.languages()) {
            dsls.add(lang.generationPackage().toLowerCase() + "." + Formatters.firstUpperCase(lang.name()));
        }
        return dsls.toArray(new String[dsls.size()]);
    }

    private Template template() {
        return Formatters.customize(MainTemplate.create());
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }
}

