/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.jms.connector;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.ChannelActionRenderer;
import io.intino.konos.builder.codegeneration.server.jms.connector.ChannelTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Bus;
import io.intino.konos.model.Schema;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ChannelRenderer {
    private final Project project;
    private final List<Bus.Channel> channels;
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public ChannelRenderer(Project project, Graph graph, File src, File gen, String packageName, String boxName) {
        this.project = project;
        this.channels = graph.find(Bus.Channel.class);
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.channels.forEach(this::processChannel);
    }

    private void processChannel(Bus.Channel channel) {
        Frame frame = new Frame().addTypes(new String[]{"channel"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{channel.name()}).addSlot("box", new String[]{this.boxName}).addSlot("subscription", new AbstractFrame[]{this.subscription(channel)});
        if (!channel.graph().find(Schema.class).isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame().addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        Commons.writeFrame(new File(this.gen, "bus"), StringHelper.snakeCaseToCamelCase((String)channel.name()) + "Channel", this.template().format((Object)frame));
        this.createCorrespondingAction(channel);
    }

    private void createCorrespondingAction(Bus.Channel channel) {
        new ChannelActionRenderer(this.project, channel, this.src, this.packageName, this.boxName).execute();
    }

    private Frame subscription(Bus.Channel channel) {
        Frame frame = new Frame().addTypes(new String[]{"subscription"}).addSlot("path", new AbstractFrame[]{this.customize(channel.path())}).addSlot("type", new String[]{channel.is(Bus.Queue.class) ? "Queue" : "Topic"}).addSlot("name", new String[]{channel.name()});
        if (channel.isDurable()) {
            frame.addSlot("durable", new AbstractFrame[]{this.customizeDurable(channel.asDurable().clientID())});
        }
        return frame;
    }

    private Frame customize(String path) {
        Frame frame = new Frame().addTypes(new String[]{"path"});
        frame.addSlot("name", new String[]{path});
        for (String parameter : Commons.extractParameters(path)) {
            frame.addSlot("custom", new String[]{parameter});
        }
        return frame;
    }

    private Frame customizeDurable(String clientId) {
        Frame frame = new Frame().addTypes(new String[]{"durable"});
        frame.addSlot("value", new String[]{""});
        for (String parameter : Commons.extractParameters(clientId)) {
            frame.addSlot("custom", new String[]{parameter});
        }
        return frame;
    }

    private Template template() {
        return Formatters.customize(ChannelTemplate.create());
    }
}

