/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.activity.web;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.server.activity.web.ActivityTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Activity;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ActivityRenderer {
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<Activity> activities;

    public ActivityRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.activities = graph.find(Activity.class);
    }

    public void execute() {
        this.activities.forEach(this::processActivity);
    }

    private void processActivity(Activity activity) {
        Frame frame = new Frame().addTypes(new String[]{"activity"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{activity.name()}).addSlot("box", new String[]{this.boxName}).addSlot("resource", (AbstractFrame[])this.resourcesFrame(activity.abstractPageList())).addSlot("display", (AbstractFrame[])this.displaysFrame(activity.displayList()));
        if (activity.authenticated() != null) {
            frame.addSlot("auth", new String[]{activity.authenticated().by()});
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)(activity.name() + "Activity")), this.template().format((Object)frame));
    }

    private Frame[] resourcesFrame(List<Activity.AbstractPage> pages) {
        List<Frame> frames = pages.stream().map(this::frameOf).collect(Collectors.toList());
        return frames.toArray(new Frame[frames.size()]);
    }

    private Frame[] displaysFrame(List<Activity.Display> displays) {
        List<Frame> frames = displays.stream().map(this::frameOf).collect(Collectors.toList());
        return frames.toArray(new Frame[frames.size()]);
    }

    private Frame frameOf(Activity.AbstractPage resource) {
        Frame frame = new Frame().addTypes(new String[]{"resource", "abstractPage"});
        frame.addSlot("name", new String[]{resource.name()});
        for (String path : resource.paths()) {
            frame.addSlot("path", new AbstractFrame[]{new Frame().addSlot("value", new String[]{path}).addSlot("name", new String[]{resource.name()})});
        }
        return frame;
    }

    private Frame frameOf(Activity.Display display) {
        Frame frame = new Frame().addTypes(new String[]{"display"});
        frame.addSlot("name", new String[]{display.name()});
        if (display.requestList().stream().anyMatch(r -> r.responseType().equals((Object)Activity.Display.Request.ResponseType.Asset))) {
            frame.addSlot("asset", new String[]{display.name()});
        }
        return frame;
    }

    private Template template() {
        Template template = ActivityTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

