/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import com.intellij.openapi.module.Module;
import cottons.utils.StringHelper;
import io.intino.konos.builder.WidgetNotifierTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.ConfigurationTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.PageTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetRequesterTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetsTemplate;
import io.intino.konos.model.Activity;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ActivityAccessorRenderer {
    private static final String SRC_DIRECTORY = "src";
    private final Module appModule;
    private final Module webModule;
    private final Activity activity;

    ActivityAccessorRenderer(Module appModule, Module webModule, Activity activity) {
        this.appModule = appModule;
        this.webModule = webModule;
        this.activity = activity;
    }

    boolean createConfigurationFile() {
        Configuration configuration = TaraUtil.configurationOf((Module)this.appModule);
        Frame frame = new Frame();
        frame.addTypes(new String[]{"configuration", "legio"});
        frame.addSlot("groupID", new String[]{configuration.groupId()});
        frame.addSlot("artifactID", new String[]{configuration.artifactId()});
        frame.addSlot("version", new String[]{configuration.version()});
        Map releaseRepositories = configuration.releaseRepositories();
        for (String repository : releaseRepositories.keySet()) {
            frame.addSlot("repository", new AbstractFrame[]{new Frame().addTypes(new String[]{"repository", "release"}).addSlot("type", new String[]{"Release"}).addSlot("url", new String[]{repository}).addSlot("id", new String[]{(String)releaseRepositories.get(repository)})});
        }
        File file = new File(this.rootDirectory(), "configuration.legio");
        if (!file.exists()) {
            try {
                return Files.write(file.toPath(), ConfigurationTemplate.create().format((Object)frame).getBytes(), new OpenOption[0]).toFile().exists();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void execute() {
        try {
            this.createStaticFiles();
            this.createWidgets();
            this.createPages();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createPages() throws IOException {
        for (Activity.AbstractPage page : this.activity.abstractPageList()) {
            Path pagePath = new File(this.rootDirectory(), SRC_DIRECTORY + File.separator + page.name() + ".html").toPath();
            if (Files.exists(pagePath, new LinkOption[0])) continue;
            Files.write(pagePath, PageTemplate.create().format((Object)this.pageFrame(page)).getBytes(), new OpenOption[0]);
        }
    }

    private Frame pageFrame(Activity.AbstractPage page) {
        return new Frame().addTypes(new String[]{"page"}).addSlot("uses", new String[]{page.uses().name()}).addSlot("name", new String[]{page.name()});
    }

    private void createWidget(Activity.Display display) throws IOException {
        Frame frame = new Frame().addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name()}).addSlot("innerDisplay", (String[])display.displays().stream().map(Layer::name).toArray(String[]::new));
        File file = new File(this.rootDirectory(), SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)display.name()).toLowerCase() + "-widget.html");
        if (!file.exists()) {
            Files.write(file.toPath(), Formatters.customize(WidgetTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
        }
    }

    private void createWidgets() throws IOException {
        Frame widgets = new Frame().addTypes(new String[]{"widgets"});
        for (Activity.Display display : this.activity.displayList()) {
            this.createNotifier(display);
            this.createRequester(display);
            this.createWidget(display);
            widgets.addSlot("widget", new String[]{display.name()});
        }
        Files.write(new File(this.rootDirectory(), SRC_DIRECTORY + File.separator + "widgets" + File.separator + "widgets.html").toPath(), Formatters.customize(WidgetsTemplate.create()).format((Object)widgets).getBytes(), new OpenOption[0]);
    }

    private void createRequester(Activity.Display display) throws IOException {
        Frame frame = new Frame().addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name()}).addSlot("requester", (AbstractFrame[])((Frame[])display.requestList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.rootDirectory(), SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name().toLowerCase() + "widget" + File.separator + "requester.js");
        file.getParentFile().mkdirs();
        Files.write(file.toPath(), Formatters.customize(WidgetRequesterTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
    }

    private void createNotifier(Activity.Display display) throws IOException {
        Frame frame = new Frame().addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name()}).addSlot("notification", (AbstractFrame[])((Frame[])display.notificationList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.rootDirectory(), SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name().toLowerCase() + "widget" + File.separator + "notifier-listener.js");
        file.getParentFile().mkdirs();
        Files.write(file.toPath(), Formatters.customize(WidgetNotifierTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
    }

    private Frame frameOf(Activity.Display.Request r) {
        Frame frame = new Frame().addTypes(new String[]{"requester"}).addSlot("name", new String[]{r.name()});
        if (r.isType()) {
            frame.addSlot("parameter", new String[]{""});
            frame.addSlot("parameterSignature", new String[]{""});
        }
        frame.addSlot("method", new String[]{r.responseType().name()});
        return frame;
    }

    private Frame frameOf(Activity.Display.Notification n) {
        Frame frame = new Frame().addTypes(new String[]{"notification"}).addSlot("name", new String[]{n.name()});
        if (n.asType() != null) {
            frame.addSlot("parameter", new String[]{""});
            frame.addSlot("to", new String[]{n.to().name()});
        }
        return frame;
    }

    private void createStaticFiles() throws IOException {
        File root = this.rootDirectory();
        new File(root, SRC_DIRECTORY + File.separator + "fonts").mkdirs();
        new File(root, SRC_DIRECTORY + File.separator + "images").mkdirs();
        new File(root, SRC_DIRECTORY + File.separator + "styles").mkdirs();
        new File(root, SRC_DIRECTORY + File.separator + "widgets").mkdirs();
        File file = new File(root, SRC_DIRECTORY + File.separator + "components.html");
        if (!file.exists()) {
            ActivityAccessorRenderer.copyStream(this.inputFrom("/ui/components.html"), new FileOutputStream(file));
        }
        if (!(file = new File(root, SRC_DIRECTORY + File.separator + "main.js")).exists()) {
            ActivityAccessorRenderer.copyStream(this.inputFrom("/ui/main.js"), new FileOutputStream(file));
        }
    }

    private File rootDirectory() {
        return new File(this.webModule.getModuleFilePath()).getParentFile();
    }

    private InputStream inputFrom(String path) {
        return this.getClass().getResourceAsStream(path);
    }

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }
}

