/*
 * Decompiled with CFR 0.152.
 */
package io.intino;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Configuration {
    default public Configuration init() {
        return null;
    }

    default public boolean isSuitable() {
        return false;
    }

    default public boolean isReloading() {
        return false;
    }

    default public void reload() {
    }

    public Artifact artifact();

    public List<Server> servers();

    public List<RunConfiguration> runConfigurations();

    public List<Repository> repositories();

    public static interface Library
    extends ConfigurationNode {
        public String groupId();

        public String artifactId();

        public String version();

        public void version(String var1);
    }

    public static interface Parameter
    extends ConfigurationNode {
        public String name();

        public String value();

        public String description();
    }

    public static interface ConfigurationNode {
        public Configuration root();

        public ConfigurationNode owner();
    }

    public static interface Server {
        public String name();

        public Type type();

        public static enum Type {
            Dev,
            Pre,
            Pro,
            Demo;

        }
    }

    public static interface Repository
    extends ConfigurationNode {
        public String identifier();

        public String url();

        public String user();

        public String password();

        public UpdatePolicy updatePolicy();

        public static interface Snapshot
        extends Repository {
        }

        public static interface Release
        extends Repository {
        }

        public static enum UpdatePolicy {
            Always,
            Daily,
            Never;

        }
    }

    public static interface RunConfiguration
    extends ConfigurationNode {
        public String name();

        public String mainClass();

        public String vmOptions();

        public List<Argument> arguments();

        default public Map<String, String> finalArguments() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            this.arguments().forEach(a -> arguments.put(a.name(), a.value()));
            Artifact artifact = this.root().artifact();
            artifact.parameters().stream().filter(p -> !arguments.containsKey(p.name())).filter(p -> p.value() != null).forEach(p -> arguments.put(p.name(), p.value()));
            return arguments;
        }

        public static interface Argument
        extends Parameter {
            @Override
            public String name();

            @Override
            public String value();

            @Override
            default public String description() {
                return "";
            }
        }
    }

    public static interface WebDependency {
    }

    public static interface Deployment {
        public Server server();

        public RunConfiguration runConfiguration();

        public List<String> bugTrackingUsers();

        public Requirements requirements();

        public static interface Requirements {
            public int minHdd();

            public int minMemory();

            public int maxMemory();

            public String jvmVersion();

            public Sync sync();

            public static interface Sync {
                public Map<String, String> moduleServer();
            }
        }
    }

    public static interface Distribution {
        public ArtifactoryDistribution onArtifactory();

        public SonatypeDistribution onSonatype();

        public BitBucketDistribution onBitbucket();

        public boolean distributeLanguage();

        public static interface BitBucketDistribution {
            public String owner();

            public String slugName();
        }

        public static interface SonatypeDistribution {
            public String identifier();
        }

        public static interface ArtifactoryDistribution {
            public Repository release();

            public Repository snapshot();
        }
    }

    public static interface Artifact
    extends ConfigurationNode {
        public String groupId();

        public String name();

        public void name(String var1);

        public String version();

        public void version(String var1);

        public String description();

        public String url();

        public License license();

        public Scm scm();

        public List<Developer> developers();

        public List<Dsl> dsls();

        default public Dsl dsl(String name) {
            return this.dsls().stream().filter(d -> d.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        }

        public Dependency.DataHub datahub();

        public Dependency.Archetype archetype();

        public List<Dependency> dependencies();

        public List<WebComponent> webComponents();

        public List<WebResolution> webResolutions();

        public List<WebArtifact> webArtifacts();

        public Code code();

        public List<Plugin> plugins();

        public QualityAnalytics qualityAnalytics();

        public Package packageConfiguration();

        public Distribution distribution();

        public List<Parameter> parameters();

        default public List<Deployment> deployments() {
            return Collections.emptyList();
        }

        public static interface Dsl
        extends ConfigurationNode {
            public String groupId();

            default public String artifactId() {
                return this.name();
            }

            public String name();

            public String version();

            public Level level();

            public String generationPackage();

            public String effectiveVersion();

            public void effectiveVersion(String var1);

            public void version(String var1);

            public Builder builder();

            public Runtime runtime();

            public OutputDsl outputDsl();

            public static interface Runtime
            extends Library {
            }

            public static interface OutputBuilder
            extends Library {
            }

            public static interface Builder
            extends Library {
                public String generationPackage();

                public List<ExcludedPhases> excludedPhases();

                public static enum ExcludedPhases {
                    ExcludeCodeBaseGeneration,
                    ExcludeLanguageGeneration;

                }
            }

            public static interface OutputDsl
            extends ConfigurationNode {
                public String groupId();

                public String artifactId();

                public String version();

                public OutputBuilder builder();

                public Runtime runtime();
            }

            public static enum Level {
                Model,
                MetaModel,
                MetaMetaModel;


                public int compareLevelWith(Level type) {
                    return type.ordinal() - this.ordinal();
                }

                public boolean is(Level type, int level) {
                    return type.ordinal() == level;
                }

                public boolean isModel() {
                    return Model.equals((Object)this);
                }

                public boolean isMetaModel() {
                    return MetaModel.equals((Object)this);
                }

                public boolean isMetaMetaModel() {
                    return MetaMetaModel.equals((Object)this);
                }
            }
        }

        public static interface Scm {
            public String url();

            public String connection();

            public String developerConnection();

            public String tag();
        }

        public static interface Package {
            public LinuxService linuxService();

            public Mode mode();

            public boolean isRunnable();

            public boolean createMavenPom();

            public boolean attachSources();

            public List<String> mavenPlugins();

            public boolean attachDoc();

            public boolean includeTests();

            public boolean signArtifactWithGpg();

            public String classpathPrefix();

            public String finalName();

            public String defaultJVMOptions();

            public String mainClass();

            public boolean isContainer();

            public MacOs macOsConfiguration();

            public Windows windowsConfiguration();

            public static interface LinuxService {
                public String user();

                public RunConfiguration runConfiguration();

                public boolean restartOnFailure();

                public int managementPort();
            }

            public static interface Windows {
                public String icon();
            }

            public static interface MacOs {
                public String icon();

                public String resourceDirectory();
            }

            public static enum Mode {
                ModulesAndLibrariesExtracted,
                LibrariesLinkedByManifest,
                ModulesAndLibrariesLinkedByManifest;

            }
        }

        public static interface Plugin
        extends Library {
            default public String identifier() {
                return this.groupId() + ":" + this.artifactId() + ":" + this.version();
            }

            default public String name() {
                return "Intino: " + this.identifier();
            }

            default public Phase phase() {
                return Phase.PrePackage;
            }

            public static enum Phase {
                Export,
                PostCompilation,
                PrePackage,
                PostPackage,
                PostDistribution;

            }
        }

        public static interface WebArtifact {
            public String name();

            default public String identifier() {
                return this.groupId() + ":" + this.artifactId() + ":" + this.version();
            }

            public String groupId();

            public String artifactId();

            public String version();
        }

        public static interface WebResolution {
            public String name();

            public String version();
        }

        public static interface WebComponent {
            public String name();

            public String version();
        }

        public static interface Developer {
            public String name();

            public String email();

            public String organization();

            public String organizationUrl();
        }

        public static interface License {
            public LicenseType type();

            public static enum LicenseType {
                GPL,
                BSD,
                LGPL;

            }
        }

        public static interface Dependency
        extends Library {
            default public String identifier() {
                return this.groupId() + ":" + this.artifactId() + ":" + this.version();
            }

            default public String name() {
                return "Intino: " + this.identifier();
            }

            @Override
            public void version(String var1);

            public String scope();

            public List<Exclude> excludes();

            public String effectiveVersion();

            public void effectiveVersion(String var1);

            public boolean transitive();

            public boolean toModule();

            public void toModule(boolean var1);

            public static interface Web
            extends Dependency {
            }

            public static interface Archetype
            extends Dependency {
            }

            public static interface DataHub
            extends Dependency {
            }

            public static interface Provided
            extends Dependency {
            }

            public static interface Runtime
            extends Dependency {
            }

            public static interface Test
            extends Dependency {
            }

            public static interface Compile
            extends Dependency {
            }

            public static interface Exclude {
                public String groupId();

                public String artifactId();
            }
        }

        public static interface Code
        extends ConfigurationNode {
            public String generationPackage();

            default public String webDirectory() {
                return "lib";
            }

            public String nativeLanguage();
        }

        public static interface QualityAnalytics {
            public String url();

            public String token();
        }
    }
}

